/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.test;

import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.extension.testcontainer.ContainerProperties;
import io.camunda.zeebe.process.test.extension.testcontainer.ContainerizedEngine;
import io.camunda.zeebe.process.test.extension.testcontainer.EngineContainer;
import io.camunda.zeebe.spring.test.AbstractZeebeTestExecutionListener;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.lang.NonNull;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;

public class ZeebeTestExecutionListener
extends AbstractZeebeTestExecutionListener
implements TestExecutionListener,
Ordered {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ContainerizedEngine containerizedEngine;

    public void beforeTestClass(@NonNull TestContext testContext) {
        LOGGER.info("Creating Zeebe Testcontainer...");
        EngineContainer container = EngineContainer.getContainer();
        container.start();
        this.containerizedEngine = new ContainerizedEngine(container.getHost(), container.getMappedPort(ContainerProperties.getContainerPort()).intValue(), container.getMappedPort(ContainerProperties.getGatewayPort()).intValue());
        LOGGER.info("...finished creating Zeebe Testcontainer");
    }

    public void beforeTestMethod(@NonNull TestContext testContext) {
        LOGGER.info("Create Zeebe Testcontainer engine");
        this.containerizedEngine.start();
        this.setupWithZeebeEngine(testContext, (ZeebeTestEngine)this.containerizedEngine);
    }

    public void afterTestMethod(@NonNull TestContext testContext) {
        this.cleanup(testContext, (ZeebeTestEngine)this.containerizedEngine);
        this.containerizedEngine.reset();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

