/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.exception.OperateException;
import io.camunda.zeebe.spring.client.properties.OperateClientConfigurationProperties;
import io.camunda.zeebe.spring.client.testsupport.SpringZeebeTestContext;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(prefix="operate.client", name={"enabled"}, havingValue="true", matchIfMissing=false)
@ConditionalOnMissingBean(value={SpringZeebeTestContext.class})
@EnableConfigurationProperties(value={OperateClientConfigurationProperties.class})
public class OperateClientProdAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${camunda.operate.client.startup.retry.maxAttempts:24}")
    private int startupRetryMaxAttempts;
    @Value(value="${camunda.operate.client.startup.retry.awaitDurationInSeconds:5}")
    private int startupRetryAwaitDurationInSeconds;

    @Bean
    public CamundaOperateClient camundaOperateClient(OperateClientConfigurationProperties props) {
        String operateUrl = props.getOperateUrl();
        RetryConfig config = RetryConfig.custom().maxAttempts(this.startupRetryMaxAttempts).waitDuration(Duration.of(this.startupRetryAwaitDurationInSeconds, ChronoUnit.SECONDS)).build();
        Retry retry = Retry.of((String)"camundaOperateClient", (RetryConfig)config);
        return (CamundaOperateClient)retry.executeSupplier(() -> {
            try {
                return new CamundaOperateClient.Builder().operateUrl(operateUrl).authentication(props.getAuthentication(operateUrl)).build();
            }
            catch (OperateException e) {
                LOG.warn("An attempt to connect to Operate failed: " + (Object)((Object)e));
                throw new RuntimeException(e);
            }
        });
    }
}

