/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.connector;

import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.util.outbound.OutboundConnectorFactory;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.connector.OutboundConnectorConfigurationComparator;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import java.lang.invoke.MethodHandles;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundConnectorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final JobWorkerManager jobWorkerManager;
    private final OutboundConnectorFactory connectorFactory;

    public OutboundConnectorManager(JobWorkerManager jobWorkerManager, OutboundConnectorFactory connectorFactory) {
        this.jobWorkerManager = jobWorkerManager;
        this.connectorFactory = connectorFactory;
    }

    public void start(ZeebeClient client) {
        TreeSet<OutboundConnectorConfiguration> outboundConnectors = new TreeSet<OutboundConnectorConfiguration>(new OutboundConnectorConfigurationComparator());
        outboundConnectors.addAll(this.connectorFactory.getConfigurations());
        outboundConnectors.forEach(connector -> this.openWorkerForOutboundConnector(client, (OutboundConnectorConfiguration)connector));
    }

    public void openWorkerForOutboundConnector(ZeebeClient client, OutboundConnectorConfiguration connector) {
        ZeebeWorkerValue zeebeWorkerValue = new ZeebeWorkerValue().setName(connector.getName()).setType(connector.getType()).setFetchVariables(connector.getInputVariables()).setAutoComplete(true);
        this.jobWorkerManager.openWorker(client, zeebeWorkerValue, connector);
    }

    public void stop(ZeebeClient client) {
        this.jobWorkerManager.closeAllOpenWorkers();
    }
}

