/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.metrics;

import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;

public class SimpleMetricsRecorder
implements MetricsRecorder {
    public HashMap<String, AtomicLong> counters = new HashMap();
    public HashMap<String, Long> timers = new HashMap();

    @Override
    public void increase(String metricName, String action, String type, int count) {
        String key = this.key(metricName, action, type);
        if (!this.counters.containsKey(key)) {
            this.counters.put(key, new AtomicLong(count));
        } else {
            this.counters.get(key).addAndGet(count);
        }
    }

    @Override
    public void executeWithTimer(String metricName, String jobType, Runnable methodToExecute) {
        long startTime = System.currentTimeMillis();
        methodToExecute.run();
        this.timers.put(metricName + "#" + jobType, System.currentTimeMillis() - startTime);
    }

    private String key(String metricName, String action, String type) {
        String key = metricName + "#" + action + "#" + type;
        return key;
    }

    public long getCount(String metricName, String action, String type) {
        if (!this.counters.containsKey(this.key(metricName, action, type))) {
            return 0L;
        }
        return this.counters.get(this.key(metricName, action, type)).get();
    }
}

