/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.bean;

import io.camunda.zeebe.spring.client.bean.BeanInfo;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import io.camunda.zeebe.spring.client.bean.ParameterInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.core.StandardReflectionParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;

public class MethodInfo
implements BeanInfo {
    private static final StandardReflectionParameterNameDiscoverer parameterNameDiscoverer = new StandardReflectionParameterNameDiscoverer();
    protected ClassInfo classInfo;
    protected Method method;

    protected MethodInfo(ClassInfo classInfo, Method method) {
        this.classInfo = classInfo;
        this.method = method;
    }

    protected MethodInfo(MethodInfo original) {
        this.classInfo = original.classInfo;
        this.method = original.method;
    }

    @Override
    public Object getBean() {
        return this.classInfo.getBean();
    }

    @Override
    public String getBeanName() {
        return this.classInfo.getBeanName();
    }

    public String getMethodName() {
        return this.method.getName();
    }

    public Object invoke(Object ... args) throws Exception {
        try {
            return this.method.invoke(this.getBean(), args);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof Exception) {
                throw (Exception)targetException;
            }
            throw new RuntimeException("Failed to invoke method: " + this.method.getName(), targetException);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to invoke method: " + this.method.getName(), e);
        }
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> type) {
        return Optional.ofNullable(AnnotationUtils.findAnnotation((Method)this.method, type));
    }

    public List<ParameterInfo> getParameters() {
        Parameter[] parameters = this.method.getParameters();
        String[] parameterNames = parameterNameDiscoverer.getParameterNames(this.method);
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        for (int i = 0; i < parameters.length; ++i) {
            result.add(new ParameterInfo(parameters[i], parameterNames[i]));
        }
        return result;
    }

    public List<ParameterInfo> getParametersFilteredByAnnotation(Class type) {
        Parameter[] parameters = this.method.getParameters();
        String[] parameterNames = parameterNameDiscoverer.getParameterNames(this.method);
        ArrayList<ParameterInfo> result = new ArrayList<ParameterInfo>();
        for (int i = 0; i < parameters.length; ++i) {
            if (!parameters[i].isAnnotationPresent(type)) continue;
            result.add(new ParameterInfo(parameters[i], parameterNames[i]));
        }
        return result;
    }

    public static MethodInfoBuilder builder() {
        return new MethodInfoBuilder();
    }

    public static final class MethodInfoBuilder {
        private ClassInfo classInfo;
        private Method method;

        private MethodInfoBuilder() {
        }

        public MethodInfoBuilder classInfo(ClassInfo classInfo) {
            this.classInfo = classInfo;
            return this;
        }

        public MethodInfoBuilder method(Method method) {
            this.method = method;
            return this;
        }

        public MethodInfo build() {
            return new MethodInfo(this.classInfo, this.method);
        }
    }
}

