/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.ErrorEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.EventDefinition;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.TerminateEventDefinition;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class EndEventValidator
implements ModelElementValidator<EndEvent> {
    private static final List<Class<? extends EventDefinition>> SUPPORTED_EVENT_DEFINITIONS = Arrays.asList(ErrorEventDefinition.class, MessageEventDefinition.class, TerminateEventDefinition.class);

    public Class<EndEvent> getElementType() {
        return EndEvent.class;
    }

    public void validate(EndEvent element, ValidationResultCollector validationResultCollector) {
        if (!element.getOutgoing().isEmpty()) {
            validationResultCollector.addError(0, "End events must not have outgoing sequence flows to other elements.");
        }
        this.validateEventDefinition(element, validationResultCollector);
    }

    private void validateEventDefinition(EndEvent element, ValidationResultCollector validationResultCollector) {
        Collection<EventDefinition> eventDefinitions = element.getEventDefinitions();
        if (eventDefinitions.size() > 1) {
            validationResultCollector.addError(0, "Must have at most one event definition");
        }
        eventDefinitions.forEach(def -> {
            if (SUPPORTED_EVENT_DEFINITIONS.stream().noneMatch(type -> type.isInstance(def))) {
                validationResultCollector.addError(0, "End events must be one of: none, error, message, or terminate");
            }
        });
    }
}

