/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.BoundaryEvent;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.ExtensionElements;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.camunda.zeebe.model.bpmn.instance.Message;
import io.camunda.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.ReceiveTask;
import io.camunda.zeebe.model.bpmn.instance.SendTask;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeSubscription;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class MessageValidator
implements ModelElementValidator<Message> {
    public Class<Message> getElementType() {
        return Message.class;
    }

    public void validate(Message element, ValidationResultCollector validationResultCollector) {
        if (this.isReferredByCatchEvent(element) || this.isReferredByReceiveTask(element) || this.isReferredByEventSubProcessStartEvent(element)) {
            this.validateName(element, validationResultCollector);
            this.validateSubscription(element, validationResultCollector);
        } else if (this.isReferredByThrowEvent(element) || this.isReferredBySendTask(element)) {
            this.validateName(element, validationResultCollector);
        } else {
            this.validateIfReferredByStartEvent(element, validationResultCollector);
        }
    }

    private void validateName(Message element, ValidationResultCollector validationResultCollector) {
        if (element.getName() == null || element.getName().isEmpty()) {
            validationResultCollector.addError(0, "Name must be present and not empty");
        }
    }

    private void validateSubscription(Message element, ValidationResultCollector validationResultCollector) {
        ExtensionElements extensionElements = element.getExtensionElements();
        if (extensionElements == null || extensionElements.getChildElementsByType(ZeebeSubscription.class).size() != 1) {
            validationResultCollector.addError(0, "Must have exactly one zeebe:subscription extension element");
        }
    }

    private void validateIfReferredByStartEvent(Message element, ValidationResultCollector validationResultCollector) {
        Collection startEvents = element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> p.getChildElementsByType(StartEvent.class).stream()).collect(Collectors.toList());
        long numReferredStartEvents = startEvents.stream().flatMap(i -> i.getEventDefinitions().stream()).filter(e -> e instanceof MessageEventDefinition && ((MessageEventDefinition)e).getMessage() == element).count();
        if (numReferredStartEvents > 1L) {
            validationResultCollector.addError(0, "A message cannot be referred by more than one start event");
        } else if (numReferredStartEvents == 1L) {
            this.validateName(element, validationResultCollector);
        }
    }

    private boolean isReferredByCatchEvent(Message element) {
        Collection<IntermediateCatchEvent> intermediateCatchEvents = this.getAllElementsByType(element, IntermediateCatchEvent.class);
        Collection<BoundaryEvent> boundaryEvents = this.getAllElementsByType(element, BoundaryEvent.class);
        return Stream.concat(intermediateCatchEvents.stream(), boundaryEvents.stream()).flatMap(i -> i.getEventDefinitions().stream()).anyMatch(e -> e instanceof MessageEventDefinition && ((MessageEventDefinition)e).getMessage() == element);
    }

    private boolean isReferredByThrowEvent(Message element) {
        Collection<IntermediateThrowEvent> intermediateCatchEvents = this.getAllElementsByType(element, IntermediateThrowEvent.class);
        Collection<EndEvent> endEvents = this.getAllElementsByType(element, EndEvent.class);
        return Stream.concat(intermediateCatchEvents.stream(), endEvents.stream()).flatMap(i -> i.getEventDefinitions().stream()).filter(MessageEventDefinition.class::isInstance).anyMatch(e -> ((MessageEventDefinition)e).getMessage() == element);
    }

    private boolean isReferredBySendTask(Message element) {
        Collection<SendTask> sendTasks = this.getAllElementsByType(element, SendTask.class);
        return sendTasks.stream().anyMatch(r -> r.getMessage() == element);
    }

    private boolean isReferredByReceiveTask(Message element) {
        Collection<ReceiveTask> receiveTasks = this.getAllElementsByType(element, ReceiveTask.class);
        return receiveTasks.stream().anyMatch(r -> r.getMessage() == element);
    }

    private boolean isReferredByEventSubProcessStartEvent(Message element) {
        Collection startEvents = element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> p.getChildElementsByType(SubProcess.class).stream()).flatMap(p -> p.getChildElementsByType(StartEvent.class).stream()).collect(Collectors.toList());
        long numReferredSubProcessStartEvents = startEvents.stream().flatMap(i -> i.getEventDefinitions().stream()).filter(e -> e instanceof MessageEventDefinition && ((MessageEventDefinition)e).getMessage() == element).count();
        return numReferredSubProcessStartEvents == 1L;
    }

    private <T extends ModelElementInstance> Collection<T> getAllElementsByType(Message element, Class<T> type) {
        return element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> this.getAllElementsByTypeRecursive((ModelElementInstance)p, type).stream()).collect(Collectors.toList());
    }

    private <T extends ModelElementInstance> Collection<T> getAllElementsByTypeRecursive(ModelElementInstance element, Class<T> type) {
        Collection result = element.getChildElementsByType(type);
        List childDomElements = element.getDomElement().getChildElements();
        Collection childModelElements = ModelUtil.getModelElementCollection((Collection)childDomElements, (ModelInstanceImpl)((ModelInstanceImpl)element.getModelInstance()));
        result.addAll(childModelElements.stream().flatMap(child -> this.getAllElementsByTypeRecursive((ModelElementInstance)child, type).stream()).collect(Collectors.toList()));
        return result;
    }
}

