/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.search;

import io.camunda.zeebe.client.api.search.response.DecisionDefinition;
import io.camunda.zeebe.client.api.search.response.DecisionRequirements;
import io.camunda.zeebe.client.api.search.response.FlowNodeInstance;
import io.camunda.zeebe.client.api.search.response.Incident;
import io.camunda.zeebe.client.api.search.response.ProcessInstance;
import io.camunda.zeebe.client.api.search.response.SearchQueryResponse;
import io.camunda.zeebe.client.api.search.response.SearchResponsePage;
import io.camunda.zeebe.client.api.search.response.UserTask;
import io.camunda.zeebe.client.impl.search.response.DecisionDefinitionImpl;
import io.camunda.zeebe.client.impl.search.response.DecisionRequirementsImpl;
import io.camunda.zeebe.client.impl.search.response.FlowNodeInstanceImpl;
import io.camunda.zeebe.client.impl.search.response.IncidentImpl;
import io.camunda.zeebe.client.impl.search.response.ProcessInstanceImpl;
import io.camunda.zeebe.client.impl.search.response.SearchQueryResponseImpl;
import io.camunda.zeebe.client.impl.search.response.SearchResponsePageImpl;
import io.camunda.zeebe.client.impl.search.response.UserTaskImpl;
import io.camunda.zeebe.client.protocol.rest.DecisionDefinitionSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.DecisionRequirementsSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.FlowNodeInstanceSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.IncidentSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.ProcessInstanceSearchQueryResponse;
import io.camunda.zeebe.client.protocol.rest.SearchQueryPageResponse;
import io.camunda.zeebe.client.protocol.rest.UserTaskSearchQueryResponse;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class SearchResponseMapper {
    private SearchResponseMapper() {
    }

    public static SearchQueryResponse<ProcessInstance> toProcessInstanceSearchResponse(ProcessInstanceSearchQueryResponse response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<ProcessInstance> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), ProcessInstanceImpl::new);
        return new SearchQueryResponseImpl<ProcessInstance>(instances, page);
    }

    public static SearchQueryResponse<UserTask> toUserTaskSearchResponse(UserTaskSearchQueryResponse response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<UserTask> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), UserTaskImpl::new);
        return new SearchQueryResponseImpl<UserTask>(instances, page);
    }

    public static SearchQueryResponse<DecisionDefinition> toDecisionDefinitionSearchResponse(DecisionDefinitionSearchQueryResponse response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<DecisionDefinition> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), DecisionDefinitionImpl::new);
        return new SearchQueryResponseImpl<DecisionDefinition>(instances, page);
    }

    public static SearchQueryResponse<FlowNodeInstance> toFlowNodeInstanceSearchResponse(FlowNodeInstanceSearchQueryResponse response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<FlowNodeInstance> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), FlowNodeInstanceImpl::new);
        return new SearchQueryResponseImpl<FlowNodeInstance>(instances, page);
    }

    public static SearchQueryResponse<Incident> toIncidentSearchResponse(IncidentSearchQueryResponse response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<Incident> incidents = SearchResponseMapper.toSearchResponseInstances(response.getItems(), IncidentImpl::new);
        return new SearchQueryResponseImpl<Incident>(incidents, page);
    }

    private static SearchResponsePage toSearchResponsePage(SearchQueryPageResponse pageResponse) {
        return new SearchResponsePageImpl(pageResponse.getTotalItems(), pageResponse.getFirstSortValues(), pageResponse.getLastSortValues());
    }

    public static SearchQueryResponse<DecisionRequirements> toDecisionRequirementsSearchResponse(DecisionRequirementsSearchQueryResponse response) {
        SearchResponsePage page = SearchResponseMapper.toSearchResponsePage(response.getPage());
        List<DecisionRequirements> instances = SearchResponseMapper.toSearchResponseInstances(response.getItems(), DecisionRequirementsImpl::new);
        return new SearchQueryResponseImpl<DecisionRequirements>(instances, page);
    }

    private static <T, R> List<R> toSearchResponseInstances(List<T> items, Function<T, R> mapper) {
        return Optional.ofNullable(items).map(i -> i.stream().map(mapper).collect(Collectors.toList())).orElse(Collections.emptyList());
    }
}

