/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.db.impl.rocksdb;

import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.protocol.EnumValue;
import io.prometheus.client.Gauge;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZeebeRocksDBMetricExporter<ColumnFamilyType extends Enum<? extends EnumValue>> {
    private static final Logger LOG = LoggerFactory.getLogger((String)ZeebeRocksDBMetricExporter.class.getName());
    private static final String PARTITION = "partition";
    private static final String ZEEBE_NAMESPACE = "zeebe";
    private static final String MEMORY_METRICS_HELP = "Everything which might be related to current memory consumption of RocksDB per column family and partition";
    private static final String MEMORY_METRICS_PREFIX = "rocksdb_memory";
    private static final RocksDBMetric[] MEMORY_METRICS = new RocksDBMetric[]{new RocksDBMetric("rocksdb.cur-size-all-mem-tables", "rocksdb_memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.cur-size-active-mem-table", "rocksdb_memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.size-all-mem-tables", "rocksdb_memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.block-cache-usage", "rocksdb_memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.block-cache-capacity", "rocksdb_memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.block-cache-pinned-usage", "rocksdb_memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition"), new RocksDBMetric("rocksdb.estimate-table-readers-mem", "rocksdb_memory", "Everything which might be related to current memory consumption of RocksDB per column family and partition")};
    private static final String SST_METRICS_HELP = "Everything which is related to SST files in RocksDB per column family and partition";
    private static final String SST_METRICS_PREFIX = "rocksdb_sst";
    private static final RocksDBMetric[] SST_METRICS = new RocksDBMetric[]{new RocksDBMetric("rocksdb.total-sst-files-size", "rocksdb_sst", "Everything which is related to SST files in RocksDB per column family and partition"), new RocksDBMetric("rocksdb.live-sst-files-size", "rocksdb_sst", "Everything which is related to SST files in RocksDB per column family and partition")};
    private static final String LIVE_METRICS_HELP = "Other estimated properties based on entries in RocksDb per column family and partition";
    private static final String LIVE_METRICS_PREFIX = "rocksdb_live";
    private static final RocksDBMetric[] LIVE_METRICS = new RocksDBMetric[]{new RocksDBMetric("rocksdb.num-entries-imm-mem-tables", "rocksdb_live", "Other estimated properties based on entries in RocksDb per column family and partition"), new RocksDBMetric("rocksdb.estimate-num-keys", "rocksdb_live", "Other estimated properties based on entries in RocksDb per column family and partition"), new RocksDBMetric("rocksdb.estimate-live-data-size", "rocksdb_live", "Other estimated properties based on entries in RocksDb per column family and partition")};
    private static final String WRITE_METRICS_HELP = "Properties related to writes, flushes and compactions for RocksDb per column family and partition";
    private static final String WRITE_METRICS_PREFIX = "rocksdb_writes";
    private static final RocksDBMetric[] WRITE_METRICS = new RocksDBMetric[]{new RocksDBMetric("rocksdb.is-write-stopped", "rocksdb_writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition"), new RocksDBMetric("rocksdb.actual-delayed-write-rate", "rocksdb_writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition"), new RocksDBMetric("rocksdb.mem-table-flush-pending", "rocksdb_writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition"), new RocksDBMetric("rocksdb.num-running-flushes", "rocksdb_writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition"), new RocksDBMetric("rocksdb.num-running-compactions", "rocksdb_writes", "Properties related to writes, flushes and compactions for RocksDb per column family and partition")};
    private final String partition;
    private final Supplier<ZeebeDb<ColumnFamilyType>> databaseSupplier;

    public ZeebeRocksDBMetricExporter(String partition, Supplier<ZeebeDb<ColumnFamilyType>> databaseSupplier) {
        this.partition = Objects.requireNonNull(partition);
        this.databaseSupplier = databaseSupplier;
    }

    public void exportMetrics() {
        long startTime = System.currentTimeMillis();
        this.exportMetrics(MEMORY_METRICS);
        this.exportMetrics(LIVE_METRICS);
        this.exportMetrics(SST_METRICS);
        this.exportMetrics(WRITE_METRICS);
        long elapsedTime = System.currentTimeMillis() - startTime;
        LOG.trace("Exporting RocksDBMetrics took + {} ms", (Object)elapsedTime);
    }

    private void exportMetrics(RocksDBMetric[] metrics) {
        ZeebeDb<ColumnFamilyType> database = this.databaseSupplier.get();
        if (database == null) {
            return;
        }
        for (RocksDBMetric metric : metrics) {
            try {
                database.getProperty(metric.getPropertyName()).map(Double::parseDouble).ifPresent(value -> metric.exportValue(this.partition, (Double)value));
            }
            catch (Exception exception) {
                LOG.debug("Error occurred on exporting metric {}", (Object)metric.getPropertyName(), (Object)exception);
            }
        }
    }

    private static final class RocksDBMetric {
        private final String propertyName;
        private final Gauge gauge;

        private RocksDBMetric(String propertyName, String namePrefix, String help) {
            this.propertyName = Objects.requireNonNull(propertyName);
            this.gauge = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace(ZeebeRocksDBMetricExporter.ZEEBE_NAMESPACE)).name(namePrefix + this.gaugeSuffix())).help(help)).labelNames(new String[]{ZeebeRocksDBMetricExporter.PARTITION})).register();
        }

        private String gaugeSuffix() {
            String suffix = "_" + this.propertyName.substring(this.propertyName.indexOf(".") + 1);
            return suffix.replaceAll("-", "_");
        }

        public void exportValue(String partitionID, Double value) {
            ((Gauge.Child)this.gauge.labels(new String[]{partitionID})).set(value.doubleValue());
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }
}

