/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.el.impl;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.EvaluationWarning;
import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.agrona.DirectBuffer;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValBoolean;
import org.camunda.feel.syntaxtree.ValContext;
import org.camunda.feel.syntaxtree.ValDate;
import org.camunda.feel.syntaxtree.ValDateTime;
import org.camunda.feel.syntaxtree.ValDayTimeDuration;
import org.camunda.feel.syntaxtree.ValList;
import org.camunda.feel.syntaxtree.ValLocalDateTime;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import org.camunda.feel.syntaxtree.ValYearMonthDuration;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;

final class FeelEvaluationResult
implements EvaluationResult {
    final Expression expression;
    final Val result;
    final List<EvaluationWarning> warnings;
    final Function<Val, DirectBuffer> messagePackTransformer;

    FeelEvaluationResult(Expression expression, Val result, List<EvaluationWarning> warnings, Function<Val, DirectBuffer> messagePackTransformer) {
        this.expression = expression;
        this.result = result;
        this.warnings = warnings;
        this.messagePackTransformer = messagePackTransformer;
    }

    @Override
    public String getExpression() {
        return this.expression.getExpression();
    }

    @Override
    public boolean isFailure() {
        return false;
    }

    @Override
    public String getFailureMessage() {
        return null;
    }

    @Override
    public List<EvaluationWarning> getWarnings() {
        return this.warnings;
    }

    @Override
    public ResultType getType() {
        Val val = this.result;
        Objects.requireNonNull(val);
        Val val2 = val;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValNull$.class, ValBoolean.class, ValNumber.class, ValString.class, ValList.class, ValContext.class, ValDayTimeDuration.class, ValYearMonthDuration.class, ValDate.class, ValDateTime.class, ValLocalDateTime.class}, (Object)val2, n)) {
            case 0 -> {
                ValNull$ ignored = (ValNull$)val2;
                yield ResultType.NULL;
            }
            case 1 -> {
                ValBoolean ignored = (ValBoolean)val2;
                yield ResultType.BOOLEAN;
            }
            case 2 -> {
                ValNumber ignored = (ValNumber)val2;
                yield ResultType.NUMBER;
            }
            case 3 -> {
                ValString ignored = (ValString)val2;
                yield ResultType.STRING;
            }
            case 4 -> {
                ValList ignored = (ValList)val2;
                yield ResultType.ARRAY;
            }
            case 5 -> {
                ValContext ignored = (ValContext)val2;
                yield ResultType.OBJECT;
            }
            case 6 -> {
                ValDayTimeDuration ignored = (ValDayTimeDuration)val2;
                yield ResultType.DURATION;
            }
            case 7 -> {
                ValYearMonthDuration ignored = (ValYearMonthDuration)val2;
                yield ResultType.PERIOD;
            }
            case 8 -> {
                ValDate ignored = (ValDate)val2;
                yield ResultType.DATE;
            }
            case 9 -> {
                ValDateTime ignored = (ValDateTime)val2;
                yield ResultType.DATE_TIME;
            }
            case 10 -> {
                ValLocalDateTime ignored = (ValLocalDateTime)val2;
                yield ResultType.DATE_TIME;
            }
            default -> ResultType.UNKNOWN;
        };
    }

    @Override
    public DirectBuffer toBuffer() {
        return this.messagePackTransformer.apply(this.result);
    }

    @Override
    public String getString() {
        Val val = this.result;
        if (val instanceof ValString) {
            ValString s = (ValString)val;
            return s.value();
        }
        return null;
    }

    @Override
    public Boolean getBoolean() {
        Val val = this.result;
        if (val instanceof ValBoolean) {
            ValBoolean b = (ValBoolean)val;
            return b.value();
        }
        return null;
    }

    @Override
    public Number getNumber() {
        Val val = this.result;
        if (val instanceof ValNumber) {
            ValNumber n = (ValNumber)val;
            return n.value();
        }
        return null;
    }

    @Override
    public Duration getDuration() {
        Val val = this.result;
        if (val instanceof ValDayTimeDuration) {
            ValDayTimeDuration d = (ValDayTimeDuration)val;
            return d.value();
        }
        return null;
    }

    @Override
    public Period getPeriod() {
        Val val = this.result;
        if (val instanceof ValYearMonthDuration) {
            ValYearMonthDuration d = (ValYearMonthDuration)val;
            return d.value();
        }
        return null;
    }

    @Override
    public ZonedDateTime getDateTime() {
        Val val = this.result;
        Objects.requireNonNull(val);
        Val val2 = val;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValDateTime.class, ValLocalDateTime.class}, (Object)val2, n)) {
            case 0 -> {
                ValDateTime dateTime = (ValDateTime)val2;
                yield dateTime.value();
            }
            case 1 -> {
                ValLocalDateTime localDateTime = (ValLocalDateTime)val2;
                yield localDateTime.value().atZone(ZoneId.systemDefault());
            }
            default -> null;
        };
    }

    @Override
    public List<DirectBuffer> getList() {
        Val val = this.result;
        if (val instanceof ValList) {
            ValList l = (ValList)val;
            return CollectionConverters.asJava((Seq)l.items().map(v -> BufferUtil.cloneBuffer((DirectBuffer)this.messagePackTransformer.apply((Val)v))));
        }
        return null;
    }

    @Override
    public List<String> getListOfStrings() {
        Val val = this.result;
        if (val instanceof ValList) {
            ValList l = (ValList)val;
            if (l.items().forall(ValString.class::isInstance)) {
                return CollectionConverters.asJava((Seq)l.items().map(v -> ((ValString)v).value()));
            }
        }
        return null;
    }
}

