/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.feel.impl;

import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackToken;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.camunda.feel.context.CustomContext;
import org.camunda.feel.context.VariableProvider;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;

public class MessagePackContext
extends CustomContext {
    public final DirectBuffer messagePackMap;
    private final VariableProvider variableProvider;

    public MessagePackContext(MsgPackReader reader, int bufferOffset, int size) {
        Map<String, Span> valueSpans = this.readValueSpans(reader, bufferOffset, size);
        this.messagePackMap = BufferUtil.cloneBuffer((DirectBuffer)reader.getBuffer(), (int)bufferOffset, (int)(reader.getOffset() - bufferOffset));
        this.variableProvider = new MessagePackMapVariableProvider(this.messagePackMap, valueSpans);
    }

    public VariableProvider variableProvider() {
        return this.variableProvider;
    }

    private Map<String, Span> readValueSpans(MsgPackReader reader, int bufferOffset, int size) {
        Builder spans = Map.newBuilder();
        spans.sizeHint(size);
        for (int i = 0; i < size; ++i) {
            MsgPackToken keyToken = reader.readToken();
            DirectBuffer keyBuffer = keyToken.getValueBuffer();
            String key = BufferUtil.bufferAsString((DirectBuffer)keyBuffer);
            int valueOffset = reader.getOffset();
            reader.skipValue();
            int valueLength = reader.getOffset() - valueOffset;
            spans.addOne((Object)new Tuple2((Object)key, (Object)new Span(valueOffset - bufferOffset, valueLength)));
        }
        return (Map)spans.result();
    }

    private static final class MessagePackMapVariableProvider
    implements VariableProvider {
        private final DirectBuffer entries;
        private final DirectBuffer resultView = new UnsafeBuffer();
        private final Map<String, Span> valueSpans;

        private MessagePackMapVariableProvider(DirectBuffer entries, Map<String, Span> valueSpans) {
            this.entries = entries;
            this.valueSpans = valueSpans;
        }

        public Option<Object> getVariable(String name) {
            return this.valueSpans.get((Object)name).map(span -> {
                this.resultView.wrap(this.entries, span.offset(), span.length());
                return this.resultView;
            });
        }

        public Iterable<String> keys() {
            return this.valueSpans.keySet();
        }

        public Map<String, Object> getVariables() {
            Builder clonedMap = Map.newBuilder();
            this.valueSpans.foreach(entry -> clonedMap.addOne((Object)new Tuple2((Object)((String)entry._1()), (Object)BufferUtil.cloneBuffer((DirectBuffer)this.entries, (int)((Span)entry._2()).offset(), (int)((Span)entry._2()).length()))));
            return (Map)clonedMap.result();
        }
    }

    record Span(int offset, int length) {
    }
}

