/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.inspections;

import io.camunda.zeebe.process.test.assertions.BpmnAssert;
import io.camunda.zeebe.process.test.filters.RecordStream;
import io.camunda.zeebe.process.test.filters.StreamFilter;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Stream;

public class FormInspectionsUtility {
    public static Optional<FormMetadataValue> findLatestFormById(String formId) {
        return FormInspectionsUtility.getForms().filter(form -> formId.equals(form.getFormId())).max(Comparator.comparingInt(FormMetadataValue::getVersion));
    }

    private static Stream<FormMetadataValue> getForms() {
        return StreamFilter.forms((RecordStream)BpmnAssert.getRecordStream()).stream().map(Record::getValue);
    }
}

