/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.inspections;

import io.camunda.zeebe.process.test.filters.ProcessInstanceRecordStreamFilter;
import io.camunda.zeebe.process.test.inspections.model.InspectedProcessInstance;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProcessInstanceInspections {
    private final ProcessInstanceRecordStreamFilter filter;

    public ProcessInstanceInspections(ProcessInstanceRecordStreamFilter filter) {
        this.filter = filter;
    }

    public ProcessInstanceInspections withParentProcessInstanceKey(long key) {
        return new ProcessInstanceInspections(this.filter.withParentProcessInstanceKey(key));
    }

    public ProcessInstanceInspections withBpmnProcessId(String bpmnProcessId) {
        return new ProcessInstanceInspections(this.filter.withBpmnProcessId(bpmnProcessId));
    }

    public Optional<InspectedProcessInstance> findFirstProcessInstance() {
        return this.findProcessInstance(0);
    }

    public Optional<InspectedProcessInstance> findLastProcessInstance() {
        List<Long> processInstanceKeys = this.getProcessInstanceKeys();
        return this.findProcessInstance(processInstanceKeys, processInstanceKeys.size() - 1);
    }

    public Optional<InspectedProcessInstance> findProcessInstance(int index) {
        List<Long> processInstanceKeys = this.getProcessInstanceKeys();
        return this.findProcessInstance(processInstanceKeys, index);
    }

    private Optional<InspectedProcessInstance> findProcessInstance(List<Long> keys, int index) {
        try {
            long processInstanceKey = keys.get(index);
            return Optional.of(new InspectedProcessInstance(processInstanceKey));
        }
        catch (IndexOutOfBoundsException ex) {
            return Optional.empty();
        }
    }

    private List<Long> getProcessInstanceKeys() {
        return this.filter.stream().map(record -> ((ProcessInstanceRecordValue)record.getValue()).getProcessInstanceKey()).filter(record -> record != -1L).collect(Collectors.toList());
    }
}

