/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.extension.testcontainer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.ZeebeObjectMapper;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.engine.protocol.EngineControlGrpc;
import io.camunda.zeebe.process.test.engine.protocol.EngineControlOuterClass;
import io.camunda.zeebe.process.test.extension.testcontainer.RecordStreamSourceImpl;
import io.camunda.zeebe.protocol.jackson.ZeebeProtocolModule;
import io.camunda.zeebe.protocol.record.Record;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ContainerizedEngine
implements ZeebeTestEngine {
    private final String host;
    private final int containerPort;
    private final int channelPort;

    public ContainerizedEngine(String host, int containerPort, int channelPort) {
        this.host = host;
        this.containerPort = containerPort;
        this.channelPort = channelPort;
    }

    public void start() {
        ManagedChannel channel = this.getChannel();
        EngineControlGrpc.EngineControlBlockingStub stub = this.getStub(channel);
        EngineControlOuterClass.StartEngineRequest request = EngineControlOuterClass.StartEngineRequest.newBuilder().build();
        stub.startEngine(request);
        this.closeChannel(channel);
    }

    public void stop() {
        ManagedChannel channel = this.getChannel();
        EngineControlGrpc.EngineControlBlockingStub stub = this.getStub(channel);
        EngineControlOuterClass.StopEngineRequest request = EngineControlOuterClass.StopEngineRequest.newBuilder().build();
        stub.stopEngine(request);
        this.closeChannel(channel);
    }

    public RecordStreamSource getRecordStreamSource() {
        return new RecordStreamSourceImpl(this, this.getRecords());
    }

    public ZeebeClient createClient() {
        return ZeebeClient.newClientBuilder().applyEnvironmentVariableOverrides(false).gatewayAddress(this.getGatewayAddress()).usePlaintext().build();
    }

    public ZeebeClient createClient(ObjectMapper objectMapper) {
        return ZeebeClient.newClientBuilder().withJsonMapper((JsonMapper)new ZeebeObjectMapper(objectMapper)).applyEnvironmentVariableOverrides(false).gatewayAddress(this.getGatewayAddress()).usePlaintext().build();
    }

    public String getGatewayAddress() {
        return this.host + ":" + this.channelPort;
    }

    public void increaseTime(Duration timeToAdd) {
        ManagedChannel channel = this.getChannel();
        EngineControlGrpc.EngineControlBlockingStub stub = this.getStub(channel);
        EngineControlOuterClass.IncreaseTimeRequest request = EngineControlOuterClass.IncreaseTimeRequest.newBuilder().setMilliseconds((int)timeToAdd.toMillis()).build();
        stub.increaseTime(request);
        this.closeChannel(channel);
    }

    public void waitForIdleState(Duration timeout) {
        ManagedChannel channel = this.getChannel();
        EngineControlGrpc.EngineControlBlockingStub stub = this.getStub(channel);
        EngineControlOuterClass.WaitForIdleStateRequest request = EngineControlOuterClass.WaitForIdleStateRequest.newBuilder().setTimeout(timeout.toMillis()).build();
        stub.waitForIdleState(request);
        this.closeChannel(channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBusyState(Duration timeout) throws InterruptedException, TimeoutException {
        ManagedChannel channel = this.getChannel();
        EngineControlGrpc.EngineControlBlockingStub stub = this.getStub(channel);
        EngineControlOuterClass.WaitForBusyStateRequest request = EngineControlOuterClass.WaitForBusyStateRequest.newBuilder().setTimeout(timeout.toMillis()).build();
        try {
            stub.waitForBusyState(request);
        }
        catch (StatusRuntimeException e) {
            if (e.getStatus().getCode().equals((Object)Status.DEADLINE_EXCEEDED.getCode())) {
                throw new TimeoutException(e.getMessage());
            }
            if (e.getStatus().getCode().equals((Object)Status.INTERNAL.getCode())) {
                throw new InterruptedException(e.getMessage());
            }
        }
        finally {
            this.closeChannel(channel);
        }
    }

    public void reset() {
        ManagedChannel channel = this.getChannel();
        EngineControlGrpc.EngineControlBlockingStub stub = this.getStub(channel);
        EngineControlOuterClass.ResetEngineRequest request = EngineControlOuterClass.ResetEngineRequest.newBuilder().build();
        stub.resetEngine(request);
        this.closeChannel(channel);
    }

    public List<Record<?>> getRecords() {
        ManagedChannel channel = this.getChannel();
        EngineControlGrpc.EngineControlBlockingStub stub = this.getStub(channel);
        ObjectMapper mapper = new ObjectMapper().registerModule((Module)new ZeebeProtocolModule());
        ArrayList mappedRecords = new ArrayList();
        EngineControlOuterClass.GetRecordsRequest request = EngineControlOuterClass.GetRecordsRequest.newBuilder().build();
        Iterator response = stub.getRecords(request);
        while (response.hasNext()) {
            EngineControlOuterClass.RecordResponse recordResponse = (EngineControlOuterClass.RecordResponse)response.next();
            try {
                Record record = (Record)mapper.readValue(recordResponse.getRecordJson(), new TypeReference<Record<?>>(){});
                mappedRecords.add(record);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        this.closeChannel(channel);
        return mappedRecords;
    }

    private ManagedChannel getChannel() {
        return ManagedChannelBuilder.forAddress((String)this.host, (int)this.containerPort).usePlaintext().build();
    }

    private EngineControlGrpc.EngineControlBlockingStub getStub(ManagedChannel channel) {
        return EngineControlGrpc.newBlockingStub((Channel)channel);
    }

    private void closeChannel(ManagedChannel channel) {
        channel.shutdown();
        try {
            channel.awaitTermination(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

