/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.BooleanProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class ProcessMetadata
extends UnifiedRecordValue
implements ProcessMetadataValue {
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty keyProp = new LongProperty("processDefinitionKey");
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final BinaryProperty checksumProp = new BinaryProperty("checksum");
    private final BooleanProperty isDuplicateProp = new BooleanProperty("isDuplicate", false);
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");
    private final LongProperty deploymentKeyProp = new LongProperty("deploymentKey", -1L);
    private final StringProperty versionTagProp = new StringProperty("versionTag", "");

    public ProcessMetadata() {
        super(9);
        this.declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.keyProp).declareProperty((BaseProperty)this.resourceNameProp).declareProperty((BaseProperty)this.checksumProp).declareProperty((BaseProperty)this.isDuplicateProp).declareProperty((BaseProperty)this.tenantIdProp).declareProperty((BaseProperty)this.deploymentKeyProp).declareProperty((BaseProperty)this.versionTagProp);
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.getKey();
    }

    public String getResourceName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.resourceNameProp.getValue());
    }

    public byte[] getChecksum() {
        return BufferUtil.bufferAsArray((DirectBuffer)this.checksumProp.getValue());
    }

    public ProcessMetadata setChecksum(DirectBuffer checksumBuffer) {
        this.checksumProp.setValue(checksumBuffer);
        return this;
    }

    public boolean isDuplicate() {
        return this.isDuplicateProp.getValue();
    }

    public ProcessMetadata setDuplicate(boolean isDuplicate) {
        this.isDuplicateProp.setValue(isDuplicate);
        return this;
    }

    public long getDeploymentKey() {
        return this.deploymentKeyProp.getValue();
    }

    public ProcessMetadata setDeploymentKey(long deploymentKey) {
        this.deploymentKeyProp.setValue(deploymentKey);
        return this;
    }

    public ProcessMetadata setResourceName(String resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ProcessMetadata setResourceName(DirectBuffer resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ProcessMetadata setVersion(int version) {
        this.versionProp.setValue(version);
        return this;
    }

    public ProcessMetadata setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public ProcessMetadata setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getChecksumBuffer() {
        return this.checksumProp.getValue();
    }

    @JsonIgnore
    public long getKey() {
        return this.keyProp.getValue();
    }

    public ProcessMetadata setKey(long key) {
        this.keyProp.setValue(key);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return super.getLength();
    }

    @Override
    @JsonIgnore
    public int getEncodedLength() {
        return super.getEncodedLength();
    }

    @JsonIgnore
    public DirectBuffer getResourceNameBuffer() {
        return this.resourceNameProp.getValue();
    }

    public ProcessMetadata setBpmnProcessId(DirectBuffer bpmnProcessId, int offset, int length) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId, offset, length);
        return this;
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public ProcessMetadata setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }

    public String getVersionTag() {
        return BufferUtil.bufferAsString((DirectBuffer)this.versionTagProp.getValue());
    }

    public ProcessMetadata setVersionTag(String versionTag) {
        this.versionTagProp.setValue(versionTag);
        return this;
    }
}

