package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue;
import io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue;
import io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource;
import io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeploymentRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeploymentRecordValue.builder()}.
 */
@Generated(from = "DeploymentRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableDeploymentRecordValue.Builder.class)
public final class ImmutableDeploymentRecordValue
    implements DeploymentRecordValue {
  private final List<DeploymentResource> resources;
  private final List<ProcessMetadataValue> processesMetadata;
  private final List<DecisionRecordValue> decisionsMetadata;
  private final List<DecisionRequirementsMetadataValue> decisionRequirementsMetadata;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableDeploymentRecordValue(
      List<DeploymentResource> resources,
      List<ProcessMetadataValue> processesMetadata,
      List<DecisionRecordValue> decisionsMetadata,
      List<DecisionRequirementsMetadataValue> decisionRequirementsMetadata) {
    this.resources = resources;
    this.processesMetadata = processesMetadata;
    this.decisionsMetadata = decisionsMetadata;
    this.decisionRequirementsMetadata = decisionRequirementsMetadata;
  }

  /**
   * @return the resources to deploy
   */
  @Override
  public List<DeploymentResource> getResources() {
    return resources;
  }

  /**
   * @return the deployed processes
   */
  @Override
  public List<ProcessMetadataValue> getProcessesMetadata() {
    return processesMetadata;
  }

  /**
   * @return the deployed decisions
   */
  @Override
  public List<DecisionRecordValue> getDecisionsMetadata() {
    return decisionsMetadata;
  }

  /**
   * @return the deployed decision requirements (DRGs)
   */
  @Override
  public List<DecisionRequirementsMetadataValue> getDecisionRequirementsMetadata() {
    return decisionRequirementsMetadata;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeploymentRecordValue#getResources() resources}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeploymentRecordValue withResources(DeploymentResource... elements) {
    List<DeploymentResource> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableDeploymentRecordValue(newValue, this.processesMetadata, this.decisionsMetadata, this.decisionRequirementsMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeploymentRecordValue#getResources() resources}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of resources elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeploymentRecordValue withResources(Iterable<? extends DeploymentResource> elements) {
    if (this.resources == elements) return this;
    List<DeploymentResource> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableDeploymentRecordValue(newValue, this.processesMetadata, this.decisionsMetadata, this.decisionRequirementsMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeploymentRecordValue withProcessesMetadata(ProcessMetadataValue... elements) {
    List<ProcessMetadataValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableDeploymentRecordValue(this.resources, newValue, this.decisionsMetadata, this.decisionRequirementsMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of processesMetadata elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeploymentRecordValue withProcessesMetadata(Iterable<? extends ProcessMetadataValue> elements) {
    if (this.processesMetadata == elements) return this;
    List<ProcessMetadataValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableDeploymentRecordValue(this.resources, newValue, this.decisionsMetadata, this.decisionRequirementsMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeploymentRecordValue withDecisionsMetadata(DecisionRecordValue... elements) {
    List<DecisionRecordValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableDeploymentRecordValue(this.resources, this.processesMetadata, newValue, this.decisionRequirementsMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of decisionsMetadata elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeploymentRecordValue withDecisionsMetadata(Iterable<? extends DecisionRecordValue> elements) {
    if (this.decisionsMetadata == elements) return this;
    List<DecisionRecordValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableDeploymentRecordValue(this.resources, this.processesMetadata, newValue, this.decisionRequirementsMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeploymentRecordValue withDecisionRequirementsMetadata(DecisionRequirementsMetadataValue... elements) {
    List<DecisionRequirementsMetadataValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableDeploymentRecordValue(this.resources, this.processesMetadata, this.decisionsMetadata, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of decisionRequirementsMetadata elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDeploymentRecordValue withDecisionRequirementsMetadata(Iterable<? extends DecisionRequirementsMetadataValue> elements) {
    if (this.decisionRequirementsMetadata == elements) return this;
    List<DecisionRequirementsMetadataValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableDeploymentRecordValue(this.resources, this.processesMetadata, this.decisionsMetadata, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeploymentRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeploymentRecordValue
        && equalTo(0, (ImmutableDeploymentRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableDeploymentRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return resources.equals(another.resources)
        && processesMetadata.equals(another.processesMetadata)
        && decisionsMetadata.equals(another.decisionsMetadata)
        && decisionRequirementsMetadata.equals(another.decisionRequirementsMetadata);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code resources}, {@code processesMetadata}, {@code decisionsMetadata}, {@code decisionRequirementsMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + resources.hashCode();
    h += (h << 5) + processesMetadata.hashCode();
    h += (h << 5) + decisionsMetadata.hashCode();
    h += (h << 5) + decisionRequirementsMetadata.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DeploymentRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeploymentRecordValue{"
        + "resources=" + resources
        + ", processesMetadata=" + processesMetadata
        + ", decisionsMetadata=" + decisionsMetadata
        + ", decisionRequirementsMetadata=" + decisionRequirementsMetadata
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DeploymentRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeploymentRecordValue instance
   */
  public static ImmutableDeploymentRecordValue copyOf(DeploymentRecordValue instance) {
    if (instance instanceof ImmutableDeploymentRecordValue) {
      return (ImmutableDeploymentRecordValue) instance;
    }
    return ImmutableDeploymentRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeploymentRecordValue ImmutableDeploymentRecordValue}.
   * <pre>
   * ImmutableDeploymentRecordValue.builder()
   *    .addResource|addAllResources(io.camunda.zeebe.protocol.record.value.deployment.DeploymentResource) // {@link DeploymentRecordValue#getResources() resources} elements
   *    .addProcessesMetadata|addAllProcessesMetadata(io.camunda.zeebe.protocol.record.value.deployment.ProcessMetadataValue) // {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata} elements
   *    .addDecisionsMetadata|addAllDecisionsMetadata(io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue) // {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata} elements
   *    .addDecisionRequirementsMetadata|addAllDecisionRequirementsMetadata(io.camunda.zeebe.protocol.record.value.deployment.DecisionRequirementsMetadataValue) // {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDeploymentRecordValue builder
   */
  public static ImmutableDeploymentRecordValue.Builder builder() {
    return new ImmutableDeploymentRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeploymentRecordValue ImmutableDeploymentRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeploymentRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> resources = new ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder>();
    private List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> processesMetadata = new ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder>();
    private List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> decisionsMetadata = new ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder>();
    private List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> decisionRequirementsMetadata = new ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeploymentRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeploymentRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      addAllResources(instance.getResources());
      addAllProcessesMetadata(instance.getProcessesMetadata());
      addAllDecisionsMetadata(instance.getDecisionsMetadata());
      addAllDecisionRequirementsMetadata(instance.getDecisionRequirementsMetadata());
      return this;
    }

    /**
     * Adds one element to {@link DeploymentRecordValue#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResource(@Nullable DeploymentResource element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(element);
      this.resources.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addResources(DeploymentResource... elements) {
      for (DeploymentResource element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(element);
        this.resources.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link DeploymentRecordValue#getResources() resources} list and returns
     * the builder.
     */
    public final io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder addResourceBuilder() {
      io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder builder = io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder();
      this.resources.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getResources() resources} list.
     * @param elements An array of resources builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResourceBuilders(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder... elements) {
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder element : elements) {
        this.resources.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link DeploymentRecordValue#getResources() resources} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> resourceBuilders() {
      return createUnmodifiableList(false, this.resources);
    }

    /**
     * Sets or replaces all elements for {@link DeploymentRecordValue#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResources(Iterable<? extends DeploymentResource> elements) {
      this.resources.clear();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends DeploymentResource> elements) {
      for (DeploymentResource element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(element);
        this.resources.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getResources() resources} list.
     * @param elements An iterable of resources builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResourceBuilders(Iterable<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> elements) {
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder element : elements) {
        this.resources.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata} list.
     * @param element A processesMetadata element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addProcessesMetadata(@Nullable ProcessMetadataValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(element);
      this.processesMetadata.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata} list.
     * @param elements An array of processesMetadata elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addProcessesMetadata(ProcessMetadataValue... elements) {
      for (ProcessMetadataValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(element);
        this.processesMetadata.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata} list and returns
     * the builder.
     */
    public final io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder addProcessesMetadataBuilder() {
      io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder builder = io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder();
      this.processesMetadata.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata} list.
     * @param elements An array of processesMetadata builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProcessesMetadataBuilders(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder... elements) {
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder element : elements) {
        this.processesMetadata.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> processesMetadataBuilders() {
      return createUnmodifiableList(false, this.processesMetadata);
    }

    /**
     * Sets or replaces all elements for {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata} list.
     * @param elements An iterable of processesMetadata elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessesMetadata(Iterable<? extends ProcessMetadataValue> elements) {
      this.processesMetadata.clear();
      return addAllProcessesMetadata(elements);
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata} list.
     * @param elements An iterable of processesMetadata elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProcessesMetadata(Iterable<? extends ProcessMetadataValue> elements) {
      for (ProcessMetadataValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(element);
        this.processesMetadata.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getProcessesMetadata() processesMetadata} list.
     * @param elements An iterable of processesMetadata builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProcessesMetadataBuilders(Iterable<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> elements) {
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder element : elements) {
        this.processesMetadata.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata} list.
     * @param element A decisionsMetadata element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDecisionsMetadata(@Nullable DecisionRecordValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(element);
      this.decisionsMetadata.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata} list.
     * @param elements An array of decisionsMetadata elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDecisionsMetadata(DecisionRecordValue... elements) {
      for (DecisionRecordValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(element);
        this.decisionsMetadata.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata} list and returns
     * the builder.
     */
    public final io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder addDecisionsMetadataBuilder() {
      io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder builder = io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder();
      this.decisionsMetadata.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata} list.
     * @param elements An array of decisionsMetadata builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDecisionsMetadataBuilders(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder... elements) {
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder element : elements) {
        this.decisionsMetadata.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> decisionsMetadataBuilders() {
      return createUnmodifiableList(false, this.decisionsMetadata);
    }

    /**
     * Sets or replaces all elements for {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata} list.
     * @param elements An iterable of decisionsMetadata elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionsMetadata(Iterable<? extends DecisionRecordValue> elements) {
      this.decisionsMetadata.clear();
      return addAllDecisionsMetadata(elements);
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata} list.
     * @param elements An iterable of decisionsMetadata elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDecisionsMetadata(Iterable<? extends DecisionRecordValue> elements) {
      for (DecisionRecordValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(element);
        this.decisionsMetadata.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getDecisionsMetadata() decisionsMetadata} list.
     * @param elements An iterable of decisionsMetadata builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDecisionsMetadataBuilders(Iterable<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> elements) {
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder element : elements) {
        this.decisionsMetadata.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata} list.
     * @param element A decisionRequirementsMetadata element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDecisionRequirementsMetadata(@Nullable DecisionRequirementsMetadataValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(element);
      this.decisionRequirementsMetadata.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata} list.
     * @param elements An array of decisionRequirementsMetadata elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addDecisionRequirementsMetadata(DecisionRequirementsMetadataValue... elements) {
      for (DecisionRequirementsMetadataValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(element);
        this.decisionRequirementsMetadata.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata} list and returns
     * the builder.
     */
    public final io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder addDecisionRequirementsMetadataBuilder() {
      io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder builder = io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder();
      this.decisionRequirementsMetadata.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata} list.
     * @param elements An array of decisionRequirementsMetadata builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDecisionRequirementsMetadataBuilders(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder... elements) {
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder element : elements) {
        this.decisionRequirementsMetadata.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> decisionRequirementsMetadataBuilders() {
      return createUnmodifiableList(false, this.decisionRequirementsMetadata);
    }

    /**
     * Sets or replaces all elements for {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata} list.
     * @param elements An iterable of decisionRequirementsMetadata elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsMetadata(Iterable<? extends DecisionRequirementsMetadataValue> elements) {
      this.decisionRequirementsMetadata.clear();
      return addAllDecisionRequirementsMetadata(elements);
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata} list.
     * @param elements An iterable of decisionRequirementsMetadata elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDecisionRequirementsMetadata(Iterable<? extends DecisionRequirementsMetadataValue> elements) {
      for (DecisionRequirementsMetadataValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(element);
        this.decisionRequirementsMetadata.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link DeploymentRecordValue#getDecisionRequirementsMetadata() decisionRequirementsMetadata} list.
     * @param elements An iterable of decisionRequirementsMetadata builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDecisionRequirementsMetadataBuilders(Iterable<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> elements) {
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder element : elements) {
        this.decisionRequirementsMetadata.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.resources.clear();
      this.processesMetadata.clear();
      this.decisionsMetadata.clear();
      this.decisionRequirementsMetadata.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeploymentRecordValue ImmutableDeploymentRecordValue}.
     * @return An immutable instance of DeploymentRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeploymentRecordValue build() {
      return new ImmutableDeploymentRecordValue(
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(resources)),
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(processesMetadata)),
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(decisionsMetadata)),
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(decisionRequirementsMetadata)));
    }



    @Nullable 
    private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(@Nullable  io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static DeploymentResource convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(@Nullable  DeploymentResource value) {
      if (value == null) return null;
      return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(value).build();
    }

    @Nullable 
    private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(@Nullable  DeploymentResource value) {
      if (value == null) return null;
      return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(value);
    }

    @Nullable 
    private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(@Nullable  io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static ProcessMetadataValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(@Nullable  ProcessMetadataValue value) {
      if (value == null) return null;
      return io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(value).build();
    }

    @Nullable 
    private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(@Nullable  ProcessMetadataValue value) {
      if (value == null) return null;
      return io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(value);
    }

    @Nullable 
    private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(@Nullable  io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static DecisionRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(@Nullable  DecisionRecordValue value) {
      if (value == null) return null;
      return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(value).build();
    }

    @Nullable 
    private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(@Nullable  DecisionRecordValue value) {
      if (value == null) return null;
      return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(value);
    }

    @Nullable 
    private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(@Nullable  io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    @Nullable 
    private static DecisionRequirementsMetadataValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(@Nullable  DecisionRequirementsMetadataValue value) {
      if (value == null) return null;
      return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(value).build();
    }

    @Nullable 
    private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(@Nullable  DecisionRequirementsMetadataValue value) {
      if (value == null) return null;
      return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(value);
    }

    private static List<DeploymentResource> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> builderList) {
      ArrayList<DeploymentResource> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<DeploymentResource> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder... builderArray) {
      ArrayList<DeploymentResource> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource> valueList) {
      ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource element : valueList) {
        list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(element));
      }
      return list;
    }

    private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource... valueArray) {
      ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource element : valueArray) {
        list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(element));
      }
      return list;
    }
    private static List<ProcessMetadataValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> builderList) {
      ArrayList<ProcessMetadataValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ProcessMetadataValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder... builderArray) {
      ArrayList<ProcessMetadataValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue> valueList) {
      ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue element : valueList) {
        list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(element));
      }
      return list;
    }

    private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue... valueArray) {
      ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue element : valueArray) {
        list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(element));
      }
      return list;
    }
    private static List<DecisionRecordValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> builderList) {
      ArrayList<DecisionRecordValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<DecisionRecordValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder... builderArray) {
      ArrayList<DecisionRecordValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue> valueList) {
      ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue element : valueList) {
        list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(element));
      }
      return list;
    }

    private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue... valueArray) {
      ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue element : valueArray) {
        list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(element));
      }
      return list;
    }
    private static List<DecisionRequirementsMetadataValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> builderList) {
      ArrayList<DecisionRequirementsMetadataValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<DecisionRequirementsMetadataValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder... builderArray) {
      ArrayList<DecisionRequirementsMetadataValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue> valueList) {
      ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue element : valueList) {
        list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(element));
      }
      return list;
    }

    private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue... valueArray) {
      ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue element : valueArray) {
        list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }



  @Nullable 
  private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(@Nullable  io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static DeploymentResource convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(@Nullable  DeploymentResource value) {
    if (value == null) return null;
    return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(value).build();
  }

  @Nullable 
  private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(@Nullable  DeploymentResource value) {
    if (value == null) return null;
    return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(value);
  }

  @Nullable 
  private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(@Nullable  io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static ProcessMetadataValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(@Nullable  ProcessMetadataValue value) {
    if (value == null) return null;
    return io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(value).build();
  }

  @Nullable 
  private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(@Nullable  ProcessMetadataValue value) {
    if (value == null) return null;
    return io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(value);
  }

  @Nullable 
  private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(@Nullable  io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static DecisionRecordValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(@Nullable  DecisionRecordValue value) {
    if (value == null) return null;
    return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(value).build();
  }

  @Nullable 
  private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(@Nullable  DecisionRecordValue value) {
    if (value == null) return null;
    return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(value);
  }

  @Nullable 
  private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(@Nullable  io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  @Nullable 
  private static DecisionRequirementsMetadataValue convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(@Nullable  DecisionRequirementsMetadataValue value) {
    if (value == null) return null;
    return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(value).build();
  }

  @Nullable 
  private static io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(@Nullable  DecisionRequirementsMetadataValue value) {
    if (value == null) return null;
    return io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(value);
  }

  private static List<DeploymentResource> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> builderList) {
    ArrayList<DeploymentResource> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<DeploymentResource> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder... builderArray) {
    ArrayList<DeploymentResource> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource> valueList) {
    ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource element : valueList) {
      list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(element));
    }
    return list;
  }

  private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDeploymentResource(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource... valueArray) {
    ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource element : valueArray) {
      list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDeploymentResource.builder().from(element));
    }
    return list;
  }
  private static List<ProcessMetadataValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> builderList) {
    ArrayList<ProcessMetadataValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ProcessMetadataValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder... builderArray) {
    ArrayList<ProcessMetadataValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue> valueList) {
    ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue element : valueList) {
      list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(element));
    }
    return list;
  }

  private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableProcessMetadataValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue... valueArray) {
    ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue element : valueArray) {
      list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableProcessMetadataValue.builder().from(element));
    }
    return list;
  }
  private static List<DecisionRecordValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> builderList) {
    ArrayList<DecisionRecordValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<DecisionRecordValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder... builderArray) {
    ArrayList<DecisionRecordValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue> valueList) {
    ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue element : valueList) {
      list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(element));
    }
    return list;
  }

  private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRecordValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue... valueArray) {
    ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue element : valueArray) {
      list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRecordValue.builder().from(element));
    }
    return list;
  }
  private static List<DecisionRequirementsMetadataValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> builderList) {
    ArrayList<DecisionRequirementsMetadataValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<DecisionRequirementsMetadataValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder... builderArray) {
    ArrayList<DecisionRequirementsMetadataValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(Iterable<? extends io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue> valueList) {
    ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue element : valueList) {
      list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(element));
    }
    return list;
  }

  private static List<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_deployment_ImmutableDecisionRequirementsMetadataValue(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue... valueArray) {
    ArrayList<io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue element : valueArray) {
      list.add(io.camunda.zeebe.protocol.record.value.deployment.ImmutableDecisionRequirementsMetadataValue.builder().from(element));
    }
    return list;
  }
}
