package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessMessageSubscriptionRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessMessageSubscriptionRecordValue.builder()}.
 */
@Generated(from = "ProcessMessageSubscriptionRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableProcessMessageSubscriptionRecordValue.Builder.class)
public final class ImmutableProcessMessageSubscriptionRecordValue
    implements ProcessMessageSubscriptionRecordValue {
  private final Map<String, Object> variables;
  private final long processInstanceKey;
  private final long elementInstanceKey;
  private final String bpmnProcessId;
  private final long messageKey;
  private final String messageName;
  private final String correlationKey;
  private final String elementId;
  private final boolean interrupting;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessMessageSubscriptionRecordValue(
      Map<String, Object> variables,
      long processInstanceKey,
      long elementInstanceKey,
      String bpmnProcessId,
      long messageKey,
      String messageName,
      String correlationKey,
      String elementId,
      boolean interrupting) {
    this.variables = variables;
    this.processInstanceKey = processInstanceKey;
    this.elementInstanceKey = elementInstanceKey;
    this.bpmnProcessId = bpmnProcessId;
    this.messageKey = messageKey;
    this.messageName = messageName;
    this.correlationKey = correlationKey;
    this.elementId = elementId;
    this.interrupting = interrupting;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   * @return the process instance key
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the element instance key
   */
  @Override
  public long getElementInstanceKey() {
    return elementInstanceKey;
  }

  /**
   * @return the BPMN process id
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the key of the correlated message
   */
  @Override
  public long getMessageKey() {
    return messageKey;
  }

  /**
   * @return the message name
   */
  @Override
  public String getMessageName() {
    return messageName;
  }

  /**
   * @return the correlation key
   */
  @Override
  public String getCorrelationKey() {
    return correlationKey;
  }

  /**
   * @return the id of the element tied to the subscription.
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * @return {@code true} if the event tied to the subscription is interrupting. Otherwise, it
   *     returns {@code false} if the event is non-interrupting.
   */
  @Override
  public boolean isInterrupting() {
    return interrupting;
  }

  /**
   * Copy the current immutable object by replacing the {@link ProcessMessageSubscriptionRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessMessageSubscriptionRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableProcessMessageSubscriptionRecordValue(
        newValue,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageKey,
        this.messageName,
        this.correlationKey,
        this.elementId,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMessageSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMessageSubscriptionRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableProcessMessageSubscriptionRecordValue(
        this.variables,
        value,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageKey,
        this.messageName,
        this.correlationKey,
        this.elementId,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMessageSubscriptionRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMessageSubscriptionRecordValue withElementInstanceKey(long value) {
    if (this.elementInstanceKey == value) return this;
    return new ImmutableProcessMessageSubscriptionRecordValue(
        this.variables,
        this.processInstanceKey,
        value,
        this.bpmnProcessId,
        this.messageKey,
        this.messageName,
        this.correlationKey,
        this.elementId,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMessageSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMessageSubscriptionRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableProcessMessageSubscriptionRecordValue(
        this.variables,
        this.processInstanceKey,
        this.elementInstanceKey,
        value,
        this.messageKey,
        this.messageName,
        this.correlationKey,
        this.elementId,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMessageSubscriptionRecordValue#getMessageKey() messageKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMessageSubscriptionRecordValue withMessageKey(long value) {
    if (this.messageKey == value) return this;
    return new ImmutableProcessMessageSubscriptionRecordValue(
        this.variables,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        value,
        this.messageName,
        this.correlationKey,
        this.elementId,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMessageSubscriptionRecordValue#getMessageName() messageName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMessageSubscriptionRecordValue withMessageName(String value) {
    if (Objects.equals(this.messageName, value)) return this;
    return new ImmutableProcessMessageSubscriptionRecordValue(
        this.variables,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageKey,
        value,
        this.correlationKey,
        this.elementId,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMessageSubscriptionRecordValue#getCorrelationKey() correlationKey} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for correlationKey (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMessageSubscriptionRecordValue withCorrelationKey(String value) {
    if (Objects.equals(this.correlationKey, value)) return this;
    return new ImmutableProcessMessageSubscriptionRecordValue(
        this.variables,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageKey,
        this.messageName,
        value,
        this.elementId,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMessageSubscriptionRecordValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMessageSubscriptionRecordValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableProcessMessageSubscriptionRecordValue(
        this.variables,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageKey,
        this.messageName,
        this.correlationKey,
        value,
        this.interrupting);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMessageSubscriptionRecordValue#isInterrupting() interrupting} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for interrupting
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMessageSubscriptionRecordValue withInterrupting(boolean value) {
    if (this.interrupting == value) return this;
    return new ImmutableProcessMessageSubscriptionRecordValue(
        this.variables,
        this.processInstanceKey,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.messageKey,
        this.messageName,
        this.correlationKey,
        this.elementId,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessMessageSubscriptionRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessMessageSubscriptionRecordValue
        && equalTo(0, (ImmutableProcessMessageSubscriptionRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessMessageSubscriptionRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && processInstanceKey == another.processInstanceKey
        && elementInstanceKey == another.elementInstanceKey
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && messageKey == another.messageKey
        && Objects.equals(messageName, another.messageName)
        && Objects.equals(correlationKey, another.correlationKey)
        && Objects.equals(elementId, another.elementId)
        && interrupting == another.interrupting;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code processInstanceKey}, {@code elementInstanceKey}, {@code bpmnProcessId}, {@code messageKey}, {@code messageName}, {@code correlationKey}, {@code elementId}, {@code interrupting}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Long.hashCode(elementInstanceKey);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + Long.hashCode(messageKey);
    h += (h << 5) + Objects.hashCode(messageName);
    h += (h << 5) + Objects.hashCode(correlationKey);
    h += (h << 5) + Objects.hashCode(elementId);
    h += (h << 5) + Boolean.hashCode(interrupting);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessMessageSubscriptionRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessMessageSubscriptionRecordValue{"
        + "variables=" + variables
        + ", processInstanceKey=" + processInstanceKey
        + ", elementInstanceKey=" + elementInstanceKey
        + ", bpmnProcessId=" + bpmnProcessId
        + ", messageKey=" + messageKey
        + ", messageName=" + messageName
        + ", correlationKey=" + correlationKey
        + ", elementId=" + elementId
        + ", interrupting=" + interrupting
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessMessageSubscriptionRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessMessageSubscriptionRecordValue instance
   */
  public static ImmutableProcessMessageSubscriptionRecordValue copyOf(ProcessMessageSubscriptionRecordValue instance) {
    if (instance instanceof ImmutableProcessMessageSubscriptionRecordValue) {
      return (ImmutableProcessMessageSubscriptionRecordValue) instance;
    }
    return ImmutableProcessMessageSubscriptionRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessMessageSubscriptionRecordValue ImmutableProcessMessageSubscriptionRecordValue}.
   * <pre>
   * ImmutableProcessMessageSubscriptionRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link ProcessMessageSubscriptionRecordValue#getVariables() variables} mappings
   *    .withProcessInstanceKey(long) // optional {@link ProcessMessageSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withElementInstanceKey(long) // optional {@link ProcessMessageSubscriptionRecordValue#getElementInstanceKey() elementInstanceKey}
   *    .withBpmnProcessId(String | null) // nullable {@link ProcessMessageSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withMessageKey(long) // optional {@link ProcessMessageSubscriptionRecordValue#getMessageKey() messageKey}
   *    .withMessageName(String | null) // nullable {@link ProcessMessageSubscriptionRecordValue#getMessageName() messageName}
   *    .withCorrelationKey(String | null) // nullable {@link ProcessMessageSubscriptionRecordValue#getCorrelationKey() correlationKey}
   *    .withElementId(String | null) // nullable {@link ProcessMessageSubscriptionRecordValue#getElementId() elementId}
   *    .withInterrupting(boolean) // optional {@link ProcessMessageSubscriptionRecordValue#isInterrupting() interrupting}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessMessageSubscriptionRecordValue builder
   */
  public static ImmutableProcessMessageSubscriptionRecordValue.Builder builder() {
    return new ImmutableProcessMessageSubscriptionRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessMessageSubscriptionRecordValue ImmutableProcessMessageSubscriptionRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessMessageSubscriptionRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private long elementInstanceKey;
    private @Nullable String bpmnProcessId;
    private long messageKey;
    private @Nullable String messageName;
    private @Nullable String correlationKey;
    private @Nullable String elementId;
    private boolean interrupting;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessMessageSubscriptionRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof ProcessMessageSubscriptionRecordValue) {
        ProcessMessageSubscriptionRecordValue instance = (ProcessMessageSubscriptionRecordValue) object;
        String messageNameValue = instance.getMessageName();
        if (messageNameValue != null) {
          withMessageName(messageNameValue);
        }
        String elementIdValue = instance.getElementId();
        if (elementIdValue != null) {
          withElementId(elementIdValue);
        }
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        withMessageKey(instance.getMessageKey());
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
        withElementInstanceKey(instance.getElementInstanceKey());
        withInterrupting(instance.isInterrupting());
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        String correlationKeyValue = instance.getCorrelationKey();
        if (correlationKeyValue != null) {
          withCorrelationKey(correlationKeyValue);
        }
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Put one entry to the {@link ProcessMessageSubscriptionRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(@Nullable String key, @Nullable Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ProcessMessageSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ProcessMessageSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ProcessMessageSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMessageSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMessageSubscriptionRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
     * @param elementInstanceKey The value for elementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementInstanceKey(long elementInstanceKey) {
      this.elementInstanceKey = elementInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMessageSubscriptionRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMessageSubscriptionRecordValue#getMessageKey() messageKey} attribute.
     * @param messageKey The value for messageKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMessageKey(long messageKey) {
      this.messageKey = messageKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMessageSubscriptionRecordValue#getMessageName() messageName} attribute.
     * @param messageName The value for messageName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMessageName(String messageName) {
      this.messageName = messageName;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMessageSubscriptionRecordValue#getCorrelationKey() correlationKey} attribute.
     * @param correlationKey The value for correlationKey (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCorrelationKey(String correlationKey) {
      this.correlationKey = correlationKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMessageSubscriptionRecordValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMessageSubscriptionRecordValue#isInterrupting() interrupting} attribute.
     * @param interrupting The value for interrupting 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withInterrupting(boolean interrupting) {
      this.interrupting = interrupting;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.processInstanceKey = 0;
      this.elementInstanceKey = 0;
      this.bpmnProcessId = null;
      this.messageKey = 0;
      this.messageName = null;
      this.correlationKey = null;
      this.elementId = null;
      this.interrupting = false;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessMessageSubscriptionRecordValue ImmutableProcessMessageSubscriptionRecordValue}.
     * @return An immutable instance of ProcessMessageSubscriptionRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessMessageSubscriptionRecordValue build() {
      return new ImmutableProcessMessageSubscriptionRecordValue(
          createUnmodifiableMap(false, false, variables),
          processInstanceKey,
          elementInstanceKey,
          bpmnProcessId,
          messageKey,
          messageName,
          correlationKey,
          elementId,
          interrupting);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
