package io.camunda.zeebe.protocol.record.value.management;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CheckpointRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCheckpointRecordValue.builder()}.
 */
@Generated(from = "CheckpointRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableCheckpointRecordValue.Builder.class)
public final class ImmutableCheckpointRecordValue
    implements CheckpointRecordValue {
  private final long checkpointId;
  private final long checkpointPosition;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableCheckpointRecordValue(long checkpointId, long checkpointPosition) {
    this.checkpointId = checkpointId;
    this.checkpointPosition = checkpointPosition;
  }

  /**
   * @return id of the checkpoint
   */
  @Override
  public long getCheckpointId() {
    return checkpointId;
  }

  /**
   * @return the position of the checkpoint
   */
  @Override
  public long getCheckpointPosition() {
    return checkpointPosition;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckpointRecordValue#getCheckpointId() checkpointId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checkpointId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckpointRecordValue withCheckpointId(long value) {
    if (this.checkpointId == value) return this;
    return new ImmutableCheckpointRecordValue(value, this.checkpointPosition);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CheckpointRecordValue#getCheckpointPosition() checkpointPosition} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for checkpointPosition
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCheckpointRecordValue withCheckpointPosition(long value) {
    if (this.checkpointPosition == value) return this;
    return new ImmutableCheckpointRecordValue(this.checkpointId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCheckpointRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCheckpointRecordValue
        && equalTo(0, (ImmutableCheckpointRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableCheckpointRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return checkpointId == another.checkpointId
        && checkpointPosition == another.checkpointPosition;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code checkpointId}, {@code checkpointPosition}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(checkpointId);
    h += (h << 5) + Long.hashCode(checkpointPosition);
    return h;
  }

  /**
   * Prints the immutable value {@code CheckpointRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CheckpointRecordValue{"
        + "checkpointId=" + checkpointId
        + ", checkpointPosition=" + checkpointPosition
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link CheckpointRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CheckpointRecordValue instance
   */
  public static ImmutableCheckpointRecordValue copyOf(CheckpointRecordValue instance) {
    if (instance instanceof ImmutableCheckpointRecordValue) {
      return (ImmutableCheckpointRecordValue) instance;
    }
    return ImmutableCheckpointRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCheckpointRecordValue ImmutableCheckpointRecordValue}.
   * <pre>
   * ImmutableCheckpointRecordValue.builder()
   *    .withCheckpointId(long) // optional {@link CheckpointRecordValue#getCheckpointId() checkpointId}
   *    .withCheckpointPosition(long) // optional {@link CheckpointRecordValue#getCheckpointPosition() checkpointPosition}
   *    .build();
   * </pre>
   * @return A new ImmutableCheckpointRecordValue builder
   */
  public static ImmutableCheckpointRecordValue.Builder builder() {
    return new ImmutableCheckpointRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCheckpointRecordValue ImmutableCheckpointRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CheckpointRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private long checkpointId;
    private long checkpointPosition;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CheckpointRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CheckpointRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      withCheckpointId(instance.getCheckpointId());
      withCheckpointPosition(instance.getCheckpointPosition());
      return this;
    }

    /**
     * Initializes the value for the {@link CheckpointRecordValue#getCheckpointId() checkpointId} attribute.
     * @param checkpointId The value for checkpointId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCheckpointId(long checkpointId) {
      this.checkpointId = checkpointId;
      return this;
    }

    /**
     * Initializes the value for the {@link CheckpointRecordValue#getCheckpointPosition() checkpointPosition} attribute.
     * @param checkpointPosition The value for checkpointPosition 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCheckpointPosition(long checkpointPosition) {
      this.checkpointPosition = checkpointPosition;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.checkpointId = 0;
      this.checkpointPosition = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCheckpointRecordValue ImmutableCheckpointRecordValue}.
     * @return An immutable instance of CheckpointRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCheckpointRecordValue build() {
      return new ImmutableCheckpointRecordValue(checkpointId, checkpointPosition);
    }



  }



}
