/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.ErrorRecordValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="ErrorRecordValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableErrorRecordValue
implements ErrorRecordValue {
    private final String exceptionMessage;
    private final String stacktrace;
    private final long errorEventPosition;
    private final long processInstanceKey;
    private transient int hashCode;

    private ImmutableErrorRecordValue(String exceptionMessage, String stacktrace, long errorEventPosition, long processInstanceKey) {
        this.exceptionMessage = exceptionMessage;
        this.stacktrace = stacktrace;
        this.errorEventPosition = errorEventPosition;
        this.processInstanceKey = processInstanceKey;
    }

    @Override
    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    @Override
    public String getStacktrace() {
        return this.stacktrace;
    }

    @Override
    public long getErrorEventPosition() {
        return this.errorEventPosition;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public final ImmutableErrorRecordValue withExceptionMessage(String value) {
        if (Objects.equals(this.exceptionMessage, value)) {
            return this;
        }
        return new ImmutableErrorRecordValue(value, this.stacktrace, this.errorEventPosition, this.processInstanceKey);
    }

    public final ImmutableErrorRecordValue withStacktrace(String value) {
        if (Objects.equals(this.stacktrace, value)) {
            return this;
        }
        return new ImmutableErrorRecordValue(this.exceptionMessage, value, this.errorEventPosition, this.processInstanceKey);
    }

    public final ImmutableErrorRecordValue withErrorEventPosition(long value) {
        if (this.errorEventPosition == value) {
            return this;
        }
        return new ImmutableErrorRecordValue(this.exceptionMessage, this.stacktrace, value, this.processInstanceKey);
    }

    public final ImmutableErrorRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableErrorRecordValue(this.exceptionMessage, this.stacktrace, this.errorEventPosition, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorRecordValue && this.equalTo(0, (ImmutableErrorRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrorRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.exceptionMessage, another.exceptionMessage) && Objects.equals(this.stacktrace, another.stacktrace) && this.errorEventPosition == another.errorEventPosition && this.processInstanceKey == another.processInstanceKey;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.exceptionMessage);
        h += (h << 5) + Objects.hashCode(this.stacktrace);
        h += (h << 5) + Long.hashCode(this.errorEventPosition);
        h += (h << 5) + Long.hashCode(this.processInstanceKey);
        return h;
    }

    public String toString() {
        return "ErrorRecordValue{exceptionMessage=" + this.exceptionMessage + ", stacktrace=" + this.stacktrace + ", errorEventPosition=" + this.errorEventPosition + ", processInstanceKey=" + this.processInstanceKey + "}";
    }

    public static ImmutableErrorRecordValue copyOf(ErrorRecordValue instance) {
        if (instance instanceof ImmutableErrorRecordValue) {
            return (ImmutableErrorRecordValue)instance;
        }
        return ImmutableErrorRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="ErrorRecordValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String exceptionMessage;
        @Nullable
        private String stacktrace;
        private long errorEventPosition;
        private long processInstanceKey;

        private Builder() {
        }

        public final Builder from(ErrorRecordValue instance) {
            String stacktraceValue;
            Objects.requireNonNull(instance, "instance");
            String exceptionMessageValue = instance.getExceptionMessage();
            if (exceptionMessageValue != null) {
                this.withExceptionMessage(exceptionMessageValue);
            }
            if ((stacktraceValue = instance.getStacktrace()) != null) {
                this.withStacktrace(stacktraceValue);
            }
            this.withErrorEventPosition(instance.getErrorEventPosition());
            this.withProcessInstanceKey(instance.getProcessInstanceKey());
            return this;
        }

        public final Builder withExceptionMessage(String exceptionMessage) {
            this.exceptionMessage = exceptionMessage;
            return this;
        }

        public final Builder withStacktrace(String stacktrace) {
            this.stacktrace = stacktrace;
            return this;
        }

        public final Builder withErrorEventPosition(long errorEventPosition) {
            this.errorEventPosition = errorEventPosition;
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public Builder clear() {
            this.exceptionMessage = null;
            this.stacktrace = null;
            this.errorEventPosition = 0L;
            this.processInstanceKey = 0L;
            return this;
        }

        public ImmutableErrorRecordValue build() {
            return new ImmutableErrorRecordValue(this.exceptionMessage, this.stacktrace, this.errorEventPosition, this.processInstanceKey);
        }
    }
}

