/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.SignalSubscriptionRecordValue;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="SignalSubscriptionRecordValue", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableSignalSubscriptionRecordValue
implements SignalSubscriptionRecordValue {
    private final long processDefinitionKey;
    private final String bpmnProcessId;
    private final String catchEventId;
    private final long catchEventInstanceKey;
    private final String signalName;
    private transient int hashCode;

    private ImmutableSignalSubscriptionRecordValue(long processDefinitionKey, String bpmnProcessId, String catchEventId, long catchEventInstanceKey, String signalName) {
        this.processDefinitionKey = processDefinitionKey;
        this.bpmnProcessId = bpmnProcessId;
        this.catchEventId = catchEventId;
        this.catchEventInstanceKey = catchEventInstanceKey;
        this.signalName = signalName;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public String getCatchEventId() {
        return this.catchEventId;
    }

    @Override
    public long getCatchEventInstanceKey() {
        return this.catchEventInstanceKey;
    }

    @Override
    public String getSignalName() {
        return this.signalName;
    }

    public final ImmutableSignalSubscriptionRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableSignalSubscriptionRecordValue(value, this.bpmnProcessId, this.catchEventId, this.catchEventInstanceKey, this.signalName);
    }

    public final ImmutableSignalSubscriptionRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableSignalSubscriptionRecordValue(this.processDefinitionKey, value, this.catchEventId, this.catchEventInstanceKey, this.signalName);
    }

    public final ImmutableSignalSubscriptionRecordValue withCatchEventId(String value) {
        if (Objects.equals(this.catchEventId, value)) {
            return this;
        }
        return new ImmutableSignalSubscriptionRecordValue(this.processDefinitionKey, this.bpmnProcessId, value, this.catchEventInstanceKey, this.signalName);
    }

    public final ImmutableSignalSubscriptionRecordValue withCatchEventInstanceKey(long value) {
        if (this.catchEventInstanceKey == value) {
            return this;
        }
        return new ImmutableSignalSubscriptionRecordValue(this.processDefinitionKey, this.bpmnProcessId, this.catchEventId, value, this.signalName);
    }

    public final ImmutableSignalSubscriptionRecordValue withSignalName(String value) {
        if (Objects.equals(this.signalName, value)) {
            return this;
        }
        return new ImmutableSignalSubscriptionRecordValue(this.processDefinitionKey, this.bpmnProcessId, this.catchEventId, this.catchEventInstanceKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSignalSubscriptionRecordValue && this.equalTo(0, (ImmutableSignalSubscriptionRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableSignalSubscriptionRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.processDefinitionKey == another.processDefinitionKey && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && Objects.equals(this.catchEventId, another.catchEventId) && this.catchEventInstanceKey == another.catchEventInstanceKey && Objects.equals(this.signalName, another.signalName);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Long.hashCode(this.processDefinitionKey);
        h += (h << 5) + Objects.hashCode(this.bpmnProcessId);
        h += (h << 5) + Objects.hashCode(this.catchEventId);
        h += (h << 5) + Long.hashCode(this.catchEventInstanceKey);
        h += (h << 5) + Objects.hashCode(this.signalName);
        return h;
    }

    public String toString() {
        return "SignalSubscriptionRecordValue{processDefinitionKey=" + this.processDefinitionKey + ", bpmnProcessId=" + this.bpmnProcessId + ", catchEventId=" + this.catchEventId + ", catchEventInstanceKey=" + this.catchEventInstanceKey + ", signalName=" + this.signalName + "}";
    }

    public static ImmutableSignalSubscriptionRecordValue copyOf(SignalSubscriptionRecordValue instance) {
        if (instance instanceof ImmutableSignalSubscriptionRecordValue) {
            return (ImmutableSignalSubscriptionRecordValue)instance;
        }
        return ImmutableSignalSubscriptionRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="SignalSubscriptionRecordValue", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private long processDefinitionKey;
        @Nullable
        private String bpmnProcessId;
        @Nullable
        private String catchEventId;
        private long catchEventInstanceKey;
        @Nullable
        private String signalName;

        private Builder() {
        }

        public final Builder from(SignalSubscriptionRecordValue instance) {
            String catchEventIdValue;
            Objects.requireNonNull(instance, "instance");
            this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
            String bpmnProcessIdValue = instance.getBpmnProcessId();
            if (bpmnProcessIdValue != null) {
                this.withBpmnProcessId(bpmnProcessIdValue);
            }
            if ((catchEventIdValue = instance.getCatchEventId()) != null) {
                this.withCatchEventId(catchEventIdValue);
            }
            this.withCatchEventInstanceKey(instance.getCatchEventInstanceKey());
            String signalNameValue = instance.getSignalName();
            if (signalNameValue != null) {
                this.withSignalName(signalNameValue);
            }
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withCatchEventId(String catchEventId) {
            this.catchEventId = catchEventId;
            return this;
        }

        public final Builder withCatchEventInstanceKey(long catchEventInstanceKey) {
            this.catchEventInstanceKey = catchEventInstanceKey;
            return this;
        }

        public final Builder withSignalName(String signalName) {
            this.signalName = signalName;
            return this;
        }

        public Builder clear() {
            this.processDefinitionKey = 0L;
            this.bpmnProcessId = null;
            this.catchEventId = null;
            this.catchEventInstanceKey = 0L;
            this.signalName = null;
            return this;
        }

        public ImmutableSignalSubscriptionRecordValue build() {
            return new ImmutableSignalSubscriptionRecordValue(this.processDefinitionKey, this.bpmnProcessId, this.catchEventId, this.catchEventInstanceKey, this.signalName);
        }
    }
}

