package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DecisionEvaluationRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDecisionEvaluationRecordValue.builder()}.
 */
@Generated(from = "DecisionEvaluationRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableDecisionEvaluationRecordValue.Builder.class)
public final class ImmutableDecisionEvaluationRecordValue
    implements DecisionEvaluationRecordValue {
  private final Map<String, Object> variables;
  private final String tenantId;
  private final long decisionKey;
  private final String decisionId;
  private final String decisionName;
  private final int decisionVersion;
  private final String decisionRequirementsId;
  private final long decisionRequirementsKey;
  private final String decisionOutput;
  private final String bpmnProcessId;
  private final long processDefinitionKey;
  private final long processInstanceKey;
  private final String elementId;
  private final long elementInstanceKey;
  private final List<EvaluatedDecisionValue> evaluatedDecisions;
  private final String evaluationFailureMessage;
  private final String failedDecisionId;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableDecisionEvaluationRecordValue(
      Map<String, Object> variables,
      String tenantId,
      long decisionKey,
      String decisionId,
      String decisionName,
      int decisionVersion,
      String decisionRequirementsId,
      long decisionRequirementsKey,
      String decisionOutput,
      String bpmnProcessId,
      long processDefinitionKey,
      long processInstanceKey,
      String elementId,
      long elementInstanceKey,
      List<EvaluatedDecisionValue> evaluatedDecisions,
      String evaluationFailureMessage,
      String failedDecisionId) {
    this.variables = variables;
    this.tenantId = tenantId;
    this.decisionKey = decisionKey;
    this.decisionId = decisionId;
    this.decisionName = decisionName;
    this.decisionVersion = decisionVersion;
    this.decisionRequirementsId = decisionRequirementsId;
    this.decisionRequirementsKey = decisionRequirementsKey;
    this.decisionOutput = decisionOutput;
    this.bpmnProcessId = bpmnProcessId;
    this.processDefinitionKey = processDefinitionKey;
    this.processInstanceKey = processInstanceKey;
    this.elementId = elementId;
    this.elementInstanceKey = elementInstanceKey;
    this.evaluatedDecisions = evaluatedDecisions;
    this.evaluationFailureMessage = evaluationFailureMessage;
    this.failedDecisionId = failedDecisionId;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the key of the evaluated decision
   */
  @Override
  public long getDecisionKey() {
    return decisionKey;
  }

  /**
   * @return the id of the evaluated decision in the DMN
   */
  @Override
  public String getDecisionId() {
    return decisionId;
  }

  /**
   * @return the name of the evaluated decision in the DMN
   */
  @Override
  public String getDecisionName() {
    return decisionName;
  }

  /**
   * @return the version of the evaluated decision
   */
  @Override
  public int getDecisionVersion() {
    return decisionVersion;
  }

  /**
   * @return the id of the DRG in the DMN the evaluated decision belongs to
   */
  @Override
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  /**
   * @return the key of the deployed DRG the evaluated decision belongs to
   */
  @Override
  public long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  /**
   * @return the output of the evaluated decision as JSON string
   */
  @Override
  public String getDecisionOutput() {
    return decisionOutput;
  }

  /**
   * @return the BPMN process id in which context the decision was evaluated
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the key of the process in which context the decision was evaluated
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the key of the process instance in which context the decision was evaluated
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the id of the element in the BPMN in which context the decision was evaluated
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * @return the key of the element instance in which context the decision was evaluated
   */
  @Override
  public long getElementInstanceKey() {
    return elementInstanceKey;
  }

  /**
   * Returns the {@link EvaluatedDecisionValue details} of the evaluated decision and its required
   * decisions. The order depends on the evaluation order, starting from the required decisions.
   * @return details of the evaluated decisions
   */
  @Override
  public List<EvaluatedDecisionValue> getEvaluatedDecisions() {
    return evaluatedDecisions;
  }

  /**
   * If the evaluation of the decision failed then it returns the reason why the evaluation of the
   * {@link #getFailedDecisionId() failed decision} was not successful. The failure message is not
   * available if the decision was evaluated successfully.
   * @return the failure message why the evaluation failed, or an empty string if the evaluation was
   *     successful
   */
  @Override
  public String getEvaluationFailureMessage() {
    return evaluationFailureMessage;
  }

  /**
   * If the evaluation of the decision failed then it returns the id of the decision where the
   * evaluation failed. It can be the called/root decision or any of its required decisions. The
   * reason of the failure can be retrieved as {@link #getEvaluationFailureMessage() evaluation
   * failure message}. The decision id is not available if the decision was evaluated successfully.
   * @return the id of the decision in the DMN where the evaluation failed, or an empty string if
   *     the evaluation was successful
   */
  @Override
  public String getFailedDecisionId() {
    return failedDecisionId;
  }

  /**
   * Copy the current immutable object by replacing the {@link DecisionEvaluationRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableDecisionEvaluationRecordValue(
        newValue,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        value,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getDecisionKey() decisionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withDecisionKey(long value) {
    if (this.decisionKey == value) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        value,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getDecisionId() decisionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withDecisionId(String value) {
    if (Objects.equals(this.decisionId, value)) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        value,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getDecisionName() decisionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withDecisionName(String value) {
    if (Objects.equals(this.decisionName, value)) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        value,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getDecisionVersion() decisionVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withDecisionVersion(int value) {
    if (this.decisionVersion == value) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        value,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getDecisionRequirementsId() decisionRequirementsId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withDecisionRequirementsId(String value) {
    if (Objects.equals(this.decisionRequirementsId, value)) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        value,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getDecisionRequirementsKey() decisionRequirementsKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withDecisionRequirementsKey(long value) {
    if (this.decisionRequirementsKey == value) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        value,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getDecisionOutput() decisionOutput} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionOutput (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withDecisionOutput(String value) {
    if (Objects.equals(this.decisionOutput, value)) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        value,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        value,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        value,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        value,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        value,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withElementInstanceKey(long value) {
    if (this.elementInstanceKey == value) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        value,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withEvaluatedDecisions(EvaluatedDecisionValue... elements) {
    List<EvaluatedDecisionValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        newValue,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of evaluatedDecisions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withEvaluatedDecisions(Iterable<? extends EvaluatedDecisionValue> elements) {
    if (this.evaluatedDecisions == elements) return this;
    List<EvaluatedDecisionValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        newValue,
        this.evaluationFailureMessage,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getEvaluationFailureMessage() evaluationFailureMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for evaluationFailureMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withEvaluationFailureMessage(String value) {
    if (Objects.equals(this.evaluationFailureMessage, value)) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        value,
        this.failedDecisionId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionEvaluationRecordValue#getFailedDecisionId() failedDecisionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for failedDecisionId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionEvaluationRecordValue withFailedDecisionId(String value) {
    if (Objects.equals(this.failedDecisionId, value)) return this;
    return new ImmutableDecisionEvaluationRecordValue(
        this.variables,
        this.tenantId,
        this.decisionKey,
        this.decisionId,
        this.decisionName,
        this.decisionVersion,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.decisionOutput,
        this.bpmnProcessId,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.elementInstanceKey,
        this.evaluatedDecisions,
        this.evaluationFailureMessage,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDecisionEvaluationRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDecisionEvaluationRecordValue
        && equalTo(0, (ImmutableDecisionEvaluationRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableDecisionEvaluationRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && Objects.equals(tenantId, another.tenantId)
        && decisionKey == another.decisionKey
        && Objects.equals(decisionId, another.decisionId)
        && Objects.equals(decisionName, another.decisionName)
        && decisionVersion == another.decisionVersion
        && Objects.equals(decisionRequirementsId, another.decisionRequirementsId)
        && decisionRequirementsKey == another.decisionRequirementsKey
        && Objects.equals(decisionOutput, another.decisionOutput)
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && processDefinitionKey == another.processDefinitionKey
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(elementId, another.elementId)
        && elementInstanceKey == another.elementInstanceKey
        && evaluatedDecisions.equals(another.evaluatedDecisions)
        && Objects.equals(evaluationFailureMessage, another.evaluationFailureMessage)
        && Objects.equals(failedDecisionId, another.failedDecisionId);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code tenantId}, {@code decisionKey}, {@code decisionId}, {@code decisionName}, {@code decisionVersion}, {@code decisionRequirementsId}, {@code decisionRequirementsKey}, {@code decisionOutput}, {@code bpmnProcessId}, {@code processDefinitionKey}, {@code processInstanceKey}, {@code elementId}, {@code elementInstanceKey}, {@code evaluatedDecisions}, {@code evaluationFailureMessage}, {@code failedDecisionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(decisionKey);
    h += (h << 5) + Objects.hashCode(decisionId);
    h += (h << 5) + Objects.hashCode(decisionName);
    h += (h << 5) + decisionVersion;
    h += (h << 5) + Objects.hashCode(decisionRequirementsId);
    h += (h << 5) + Long.hashCode(decisionRequirementsKey);
    h += (h << 5) + Objects.hashCode(decisionOutput);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(elementId);
    h += (h << 5) + Long.hashCode(elementInstanceKey);
    h += (h << 5) + evaluatedDecisions.hashCode();
    h += (h << 5) + Objects.hashCode(evaluationFailureMessage);
    h += (h << 5) + Objects.hashCode(failedDecisionId);
    return h;
  }

  /**
   * Prints the immutable value {@code DecisionEvaluationRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DecisionEvaluationRecordValue{"
        + "variables=" + variables
        + ", tenantId=" + tenantId
        + ", decisionKey=" + decisionKey
        + ", decisionId=" + decisionId
        + ", decisionName=" + decisionName
        + ", decisionVersion=" + decisionVersion
        + ", decisionRequirementsId=" + decisionRequirementsId
        + ", decisionRequirementsKey=" + decisionRequirementsKey
        + ", decisionOutput=" + decisionOutput
        + ", bpmnProcessId=" + bpmnProcessId
        + ", processDefinitionKey=" + processDefinitionKey
        + ", processInstanceKey=" + processInstanceKey
        + ", elementId=" + elementId
        + ", elementInstanceKey=" + elementInstanceKey
        + ", evaluatedDecisions=" + evaluatedDecisions
        + ", evaluationFailureMessage=" + evaluationFailureMessage
        + ", failedDecisionId=" + failedDecisionId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DecisionEvaluationRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DecisionEvaluationRecordValue instance
   */
  public static ImmutableDecisionEvaluationRecordValue copyOf(DecisionEvaluationRecordValue instance) {
    if (instance instanceof ImmutableDecisionEvaluationRecordValue) {
      return (ImmutableDecisionEvaluationRecordValue) instance;
    }
    return ImmutableDecisionEvaluationRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDecisionEvaluationRecordValue ImmutableDecisionEvaluationRecordValue}.
   * <pre>
   * ImmutableDecisionEvaluationRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link DecisionEvaluationRecordValue#getVariables() variables} mappings
   *    .withTenantId(String | null) // nullable {@link DecisionEvaluationRecordValue#getTenantId() tenantId}
   *    .withDecisionKey(long) // optional {@link DecisionEvaluationRecordValue#getDecisionKey() decisionKey}
   *    .withDecisionId(String | null) // nullable {@link DecisionEvaluationRecordValue#getDecisionId() decisionId}
   *    .withDecisionName(String | null) // nullable {@link DecisionEvaluationRecordValue#getDecisionName() decisionName}
   *    .withDecisionVersion(int) // optional {@link DecisionEvaluationRecordValue#getDecisionVersion() decisionVersion}
   *    .withDecisionRequirementsId(String | null) // nullable {@link DecisionEvaluationRecordValue#getDecisionRequirementsId() decisionRequirementsId}
   *    .withDecisionRequirementsKey(long) // optional {@link DecisionEvaluationRecordValue#getDecisionRequirementsKey() decisionRequirementsKey}
   *    .withDecisionOutput(String | null) // nullable {@link DecisionEvaluationRecordValue#getDecisionOutput() decisionOutput}
   *    .withBpmnProcessId(String | null) // nullable {@link DecisionEvaluationRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withProcessDefinitionKey(long) // optional {@link DecisionEvaluationRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withProcessInstanceKey(long) // optional {@link DecisionEvaluationRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withElementId(String | null) // nullable {@link DecisionEvaluationRecordValue#getElementId() elementId}
   *    .withElementInstanceKey(long) // optional {@link DecisionEvaluationRecordValue#getElementInstanceKey() elementInstanceKey}
   *    .addEvaluatedDecision|addAllEvaluatedDecisions(io.camunda.zeebe.protocol.record.value.EvaluatedDecisionValue) // {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions} elements
   *    .withEvaluationFailureMessage(String | null) // nullable {@link DecisionEvaluationRecordValue#getEvaluationFailureMessage() evaluationFailureMessage}
   *    .withFailedDecisionId(String | null) // nullable {@link DecisionEvaluationRecordValue#getFailedDecisionId() failedDecisionId}
   *    .build();
   * </pre>
   * @return A new ImmutableDecisionEvaluationRecordValue builder
   */
  public static ImmutableDecisionEvaluationRecordValue.Builder builder() {
    return new ImmutableDecisionEvaluationRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDecisionEvaluationRecordValue ImmutableDecisionEvaluationRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DecisionEvaluationRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private String tenantId;
    private long decisionKey;
    private String decisionId;
    private String decisionName;
    private int decisionVersion;
    private String decisionRequirementsId;
    private long decisionRequirementsKey;
    private String decisionOutput;
    private String bpmnProcessId;
    private long processDefinitionKey;
    private long processInstanceKey;
    private String elementId;
    private long elementInstanceKey;
    private List<ImmutableEvaluatedDecisionValue.Builder> evaluatedDecisions = new ArrayList<ImmutableEvaluatedDecisionValue.Builder>();
    private String evaluationFailureMessage;
    private String failedDecisionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.DecisionEvaluationRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DecisionEvaluationRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x1L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x1L;
        }
      }
      if (object instanceof DecisionEvaluationRecordValue) {
        DecisionEvaluationRecordValue instance = (DecisionEvaluationRecordValue) object;
        String elementIdValue = instance.getElementId();
        if (elementIdValue != null) {
          withElementId(elementIdValue);
        }
        withProcessInstanceKey(instance.getProcessInstanceKey());
        if ((bits & 0x1L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x1L;
        }
        withDecisionRequirementsKey(instance.getDecisionRequirementsKey());
        withDecisionKey(instance.getDecisionKey());
        withDecisionVersion(instance.getDecisionVersion());
        String decisionNameValue = instance.getDecisionName();
        if (decisionNameValue != null) {
          withDecisionName(decisionNameValue);
        }
        String decisionRequirementsIdValue = instance.getDecisionRequirementsId();
        if (decisionRequirementsIdValue != null) {
          withDecisionRequirementsId(decisionRequirementsIdValue);
        }
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
        addAllEvaluatedDecisions(instance.getEvaluatedDecisions());
        withElementInstanceKey(instance.getElementInstanceKey());
        String decisionOutputValue = instance.getDecisionOutput();
        if (decisionOutputValue != null) {
          withDecisionOutput(decisionOutputValue);
        }
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        String decisionIdValue = instance.getDecisionId();
        if (decisionIdValue != null) {
          withDecisionId(decisionIdValue);
        }
        String failedDecisionIdValue = instance.getFailedDecisionId();
        if (failedDecisionIdValue != null) {
          withFailedDecisionId(failedDecisionIdValue);
        }
        String evaluationFailureMessageValue = instance.getEvaluationFailureMessage();
        if (evaluationFailureMessageValue != null) {
          withEvaluationFailureMessage(evaluationFailureMessageValue);
        }
      }
    }

    /**
     * Put one entry to the {@link DecisionEvaluationRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link DecisionEvaluationRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DecisionEvaluationRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DecisionEvaluationRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getDecisionKey() decisionKey} attribute.
     * @param decisionKey The value for decisionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionKey(long decisionKey) {
      this.decisionKey = decisionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getDecisionId() decisionId} attribute.
     * @param decisionId The value for decisionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionId(String decisionId) {
      this.decisionId = decisionId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getDecisionName() decisionName} attribute.
     * @param decisionName The value for decisionName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionName(String decisionName) {
      this.decisionName = decisionName;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getDecisionVersion() decisionVersion} attribute.
     * @param decisionVersion The value for decisionVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionVersion(int decisionVersion) {
      this.decisionVersion = decisionVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getDecisionRequirementsId() decisionRequirementsId} attribute.
     * @param decisionRequirementsId The value for decisionRequirementsId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsId(String decisionRequirementsId) {
      this.decisionRequirementsId = decisionRequirementsId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getDecisionRequirementsKey() decisionRequirementsKey} attribute.
     * @param decisionRequirementsKey The value for decisionRequirementsKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsKey(long decisionRequirementsKey) {
      this.decisionRequirementsKey = decisionRequirementsKey;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getDecisionOutput() decisionOutput} attribute.
     * @param decisionOutput The value for decisionOutput (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionOutput(String decisionOutput) {
      this.decisionOutput = decisionOutput;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
     * @param elementInstanceKey The value for elementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementInstanceKey(long elementInstanceKey) {
      this.elementInstanceKey = elementInstanceKey;
      return this;
    }

    /**
     * Adds one element to {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions} list.
     * @param element A evaluatedDecisions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEvaluatedDecision(EvaluatedDecisionValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(element);
      this.evaluatedDecisions.add(ImmutableEvaluatedDecisionValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions} list.
     * @param elements An array of evaluatedDecisions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEvaluatedDecisions(EvaluatedDecisionValue... elements) {
      for (EvaluatedDecisionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(element);
        this.evaluatedDecisions.add(ImmutableEvaluatedDecisionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions} list and returns
     * the builder.
     */
    public final ImmutableEvaluatedDecisionValue.Builder addEvaluatedDecisionBuilder() {
      ImmutableEvaluatedDecisionValue.Builder builder = ImmutableEvaluatedDecisionValue.builder();
      this.evaluatedDecisions.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions} list.
     * @param elements An array of evaluatedDecisions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvaluatedDecisionBuilders(ImmutableEvaluatedDecisionValue.Builder... elements) {
      for (ImmutableEvaluatedDecisionValue.Builder element : elements) {
        this.evaluatedDecisions.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableEvaluatedDecisionValue.Builder> evaluatedDecisionBuilders() {
      return createUnmodifiableList(false, this.evaluatedDecisions);
    }

    /**
     * Sets or replaces all elements for {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions} list.
     * @param elements An iterable of evaluatedDecisions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withEvaluatedDecisions(Iterable<? extends EvaluatedDecisionValue> elements) {
      this.evaluatedDecisions.clear();
      return addAllEvaluatedDecisions(elements);
    }

    /**
     * Adds elements to {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions} list.
     * @param elements An iterable of evaluatedDecisions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvaluatedDecisions(Iterable<? extends EvaluatedDecisionValue> elements) {
      for (EvaluatedDecisionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(element);
        this.evaluatedDecisions.add(ImmutableEvaluatedDecisionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link DecisionEvaluationRecordValue#getEvaluatedDecisions() evaluatedDecisions} list.
     * @param elements An iterable of evaluatedDecisions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvaluatedDecisionBuilders(Iterable<ImmutableEvaluatedDecisionValue.Builder> elements) {
      for (ImmutableEvaluatedDecisionValue.Builder element : elements) {
        this.evaluatedDecisions.add(element);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getEvaluationFailureMessage() evaluationFailureMessage} attribute.
     * @param evaluationFailureMessage The value for evaluationFailureMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withEvaluationFailureMessage(String evaluationFailureMessage) {
      this.evaluationFailureMessage = evaluationFailureMessage;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionEvaluationRecordValue#getFailedDecisionId() failedDecisionId} attribute.
     * @param failedDecisionId The value for failedDecisionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFailedDecisionId(String failedDecisionId) {
      this.failedDecisionId = failedDecisionId;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.tenantId = null;
      this.decisionKey = 0;
      this.decisionId = null;
      this.decisionName = null;
      this.decisionVersion = 0;
      this.decisionRequirementsId = null;
      this.decisionRequirementsKey = 0;
      this.decisionOutput = null;
      this.bpmnProcessId = null;
      this.processDefinitionKey = 0;
      this.processInstanceKey = 0;
      this.elementId = null;
      this.elementInstanceKey = 0;
      this.evaluatedDecisions.clear();
      this.evaluationFailureMessage = null;
      this.failedDecisionId = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDecisionEvaluationRecordValue ImmutableDecisionEvaluationRecordValue}.
     * @return An immutable instance of DecisionEvaluationRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDecisionEvaluationRecordValue build() {
      return new ImmutableDecisionEvaluationRecordValue(
          createUnmodifiableMap(false, false, variables),
          tenantId,
          decisionKey,
          decisionId,
          decisionName,
          decisionVersion,
          decisionRequirementsId,
          decisionRequirementsKey,
          decisionOutput,
          bpmnProcessId,
          processDefinitionKey,
          processInstanceKey,
          elementId,
          elementInstanceKey,
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(evaluatedDecisions)),
          evaluationFailureMessage,
          failedDecisionId);
    }



    
    private static ImmutableEvaluatedDecisionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue( ImmutableEvaluatedDecisionValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    
    private static EvaluatedDecisionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue( EvaluatedDecisionValue value) {
      if (value == null) return null;
      return ImmutableEvaluatedDecisionValue.builder().from(value).build();
    }

    
    private static ImmutableEvaluatedDecisionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue( EvaluatedDecisionValue value) {
      if (value == null) return null;
      return ImmutableEvaluatedDecisionValue.builder().from(value);
    }

    private static List<EvaluatedDecisionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(Iterable<? extends ImmutableEvaluatedDecisionValue.Builder> builderList) {
      ArrayList<EvaluatedDecisionValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableEvaluatedDecisionValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<EvaluatedDecisionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(ImmutableEvaluatedDecisionValue.Builder... builderArray) {
      ArrayList<EvaluatedDecisionValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableEvaluatedDecisionValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableEvaluatedDecisionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(Iterable<? extends ImmutableEvaluatedDecisionValue> valueList) {
      ArrayList<ImmutableEvaluatedDecisionValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
      }
      list = new ArrayList<>();
      for (ImmutableEvaluatedDecisionValue element : valueList) {
        list.add(ImmutableEvaluatedDecisionValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableEvaluatedDecisionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(ImmutableEvaluatedDecisionValue... valueArray) {
      ArrayList<ImmutableEvaluatedDecisionValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>();
      for (ImmutableEvaluatedDecisionValue element : valueArray) {
        list.add(ImmutableEvaluatedDecisionValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



  
  private static ImmutableEvaluatedDecisionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue( ImmutableEvaluatedDecisionValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  
  private static EvaluatedDecisionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue( EvaluatedDecisionValue value) {
    if (value == null) return null;
    return ImmutableEvaluatedDecisionValue.builder().from(value).build();
  }

  
  private static ImmutableEvaluatedDecisionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue( EvaluatedDecisionValue value) {
    if (value == null) return null;
    return ImmutableEvaluatedDecisionValue.builder().from(value);
  }

  private static List<EvaluatedDecisionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(Iterable<? extends ImmutableEvaluatedDecisionValue.Builder> builderList) {
    ArrayList<EvaluatedDecisionValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableEvaluatedDecisionValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<EvaluatedDecisionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(ImmutableEvaluatedDecisionValue.Builder... builderArray) {
    ArrayList<EvaluatedDecisionValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableEvaluatedDecisionValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableEvaluatedDecisionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(Iterable<? extends ImmutableEvaluatedDecisionValue> valueList) {
    ArrayList<ImmutableEvaluatedDecisionValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
    }
    list = new ArrayList<>();
    for (ImmutableEvaluatedDecisionValue element : valueList) {
      list.add(ImmutableEvaluatedDecisionValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableEvaluatedDecisionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedDecisionValue(ImmutableEvaluatedDecisionValue... valueArray) {
    ArrayList<ImmutableEvaluatedDecisionValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>();
    for (ImmutableEvaluatedDecisionValue element : valueArray) {
      list.add(ImmutableEvaluatedDecisionValue.builder().from(element));
    }
    return list;
  }
}
