package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceModificationTerminateInstructionValue.builder()}.
 */
@Generated(from = "ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceModificationTerminateInstructionValue.Builder.class)
public final class ImmutableProcessInstanceModificationTerminateInstructionValue
    implements ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue {
  private final long elementInstanceKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceModificationTerminateInstructionValue(long elementInstanceKey) {
    this.elementInstanceKey = elementInstanceKey;
  }

  /**
   *Returns the key of element instance to terminate. 
   */
  @Override
  public long getElementInstanceKey() {
    return elementInstanceKey;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue#getElementInstanceKey() elementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceModificationTerminateInstructionValue withElementInstanceKey(long value) {
    if (this.elementInstanceKey == value) return this;
    return new ImmutableProcessInstanceModificationTerminateInstructionValue(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceModificationTerminateInstructionValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceModificationTerminateInstructionValue
        && equalTo(0, (ImmutableProcessInstanceModificationTerminateInstructionValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceModificationTerminateInstructionValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return elementInstanceKey == another.elementInstanceKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code elementInstanceKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(elementInstanceKey);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceModificationTerminateInstructionValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceModificationTerminateInstructionValue{"
        + "elementInstanceKey=" + elementInstanceKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceModificationTerminateInstructionValue instance
   */
  public static ImmutableProcessInstanceModificationTerminateInstructionValue copyOf(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue instance) {
    if (instance instanceof ImmutableProcessInstanceModificationTerminateInstructionValue) {
      return (ImmutableProcessInstanceModificationTerminateInstructionValue) instance;
    }
    return ImmutableProcessInstanceModificationTerminateInstructionValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceModificationTerminateInstructionValue ImmutableProcessInstanceModificationTerminateInstructionValue}.
   * <pre>
   * ImmutableProcessInstanceModificationTerminateInstructionValue.builder()
   *    .withElementInstanceKey(long) // optional {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue#getElementInstanceKey() elementInstanceKey}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceModificationTerminateInstructionValue builder
   */
  public static ImmutableProcessInstanceModificationTerminateInstructionValue.Builder builder() {
    return new ImmutableProcessInstanceModificationTerminateInstructionValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceModificationTerminateInstructionValue ImmutableProcessInstanceModificationTerminateInstructionValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private long elementInstanceKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessInstanceModificationTerminateInstructionValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue instance) {
      Objects.requireNonNull(instance, "instance");
      withElementInstanceKey(instance.getElementInstanceKey());
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue#getElementInstanceKey() elementInstanceKey} attribute.
     * @param elementInstanceKey The value for elementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementInstanceKey(long elementInstanceKey) {
      this.elementInstanceKey = elementInstanceKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.elementInstanceKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceModificationTerminateInstructionValue ImmutableProcessInstanceModificationTerminateInstructionValue}.
     * @return An immutable instance of ProcessInstanceModificationTerminateInstructionValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceModificationTerminateInstructionValue build() {
      return new ImmutableProcessInstanceModificationTerminateInstructionValue(elementInstanceKey);
    }



  }



}
