package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceModificationVariableInstructionValue.builder()}.
 */
@Generated(from = "ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceModificationVariableInstructionValue.Builder.class)
public final class ImmutableProcessInstanceModificationVariableInstructionValue
    implements ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue {
  private final Map<String, Object> variables;
  private final String elementId;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceModificationVariableInstructionValue(Map<String, Object> variables, String elementId) {
    this.variables = variables;
    this.elementId = elementId;
  }

  /**
   *Returns the variables of this instruction. Can be empty. 
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   * Returns the element id of the scope where the variables should be created in, or an empty
   * string if the variables are global for the process instance.
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * Copy the current immutable object by replacing the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceModificationVariableInstructionValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableProcessInstanceModificationVariableInstructionValue(newValue, this.elementId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceModificationVariableInstructionValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableProcessInstanceModificationVariableInstructionValue(this.variables, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceModificationVariableInstructionValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceModificationVariableInstructionValue
        && equalTo(0, (ImmutableProcessInstanceModificationVariableInstructionValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceModificationVariableInstructionValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && Objects.equals(elementId, another.elementId);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code elementId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Objects.hashCode(elementId);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceModificationVariableInstructionValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceModificationVariableInstructionValue{"
        + "variables=" + variables
        + ", elementId=" + elementId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceModificationVariableInstructionValue instance
   */
  public static ImmutableProcessInstanceModificationVariableInstructionValue copyOf(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue instance) {
    if (instance instanceof ImmutableProcessInstanceModificationVariableInstructionValue) {
      return (ImmutableProcessInstanceModificationVariableInstructionValue) instance;
    }
    return ImmutableProcessInstanceModificationVariableInstructionValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceModificationVariableInstructionValue ImmutableProcessInstanceModificationVariableInstructionValue}.
   * <pre>
   * ImmutableProcessInstanceModificationVariableInstructionValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue#getVariables() variables} mappings
   *    .withElementId(String | null) // nullable {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue#getElementId() elementId}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceModificationVariableInstructionValue builder
   */
  public static ImmutableProcessInstanceModificationVariableInstructionValue.Builder builder() {
    return new ImmutableProcessInstanceModificationVariableInstructionValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceModificationVariableInstructionValue ImmutableProcessInstanceModificationVariableInstructionValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private String elementId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessInstanceModificationVariableInstructionValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue instance) {
      Objects.requireNonNull(instance, "instance");
      putAllVariables(instance.getVariables());
      String elementIdValue = instance.getElementId();
      if (elementIdValue != null) {
        withElementId(elementIdValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.elementId = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceModificationVariableInstructionValue ImmutableProcessInstanceModificationVariableInstructionValue}.
     * @return An immutable instance of ProcessInstanceModificationVariableInstructionValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceModificationVariableInstructionValue build() {
      return new ImmutableProcessInstanceModificationVariableInstructionValue(createUnmodifiableMap(false, false, variables), elementId);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
