package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Form}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableForm.builder()}.
 */
@Generated(from = "Form", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableForm.Builder.class)
public final class ImmutableForm implements Form {
  private final String tenantId;
  private final String formId;
  private final int version;
  private final long formKey;
  private final String resourceName;
  private final byte[] checksum;
  private final boolean duplicate;
  private final byte[] resource;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableForm(
      String tenantId,
      String formId,
      int version,
      long formKey,
      String resourceName,
      byte[] checksum,
      boolean duplicate,
      byte[] resource) {
    this.tenantId = tenantId;
    this.formId = formId;
    this.version = version;
    this.formKey = formKey;
    this.resourceName = resourceName;
    this.checksum = checksum;
    this.duplicate = duplicate;
    this.resource = resource;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the ID of the form
   */
  @Override
  public String getFormId() {
    return formId;
  }

  /**
   * @return the version of the deployed form
   */
  @Override
  public int getVersion() {
    return version;
  }

  /**
   * @return the key of the deployed form
   */
  @Override
  public long getFormKey() {
    return formKey;
  }

  /**
   * @return the name of the resource through which this form was deployed
   */
  @Override
  public String getResourceName() {
    return resourceName;
  }

  /**
   * @return the checksum of the form resource (MD5)
   */
  @Override
  public byte[] getChecksum() {
    return checksum;
  }

  /**
   * @return {@code true} if the form is a duplicate (and has been deployed previously), otherwise
   *     {@code false}
   */
  @Override
  public boolean isDuplicate() {
    return duplicate;
  }

  /**
   * @return returns the corresponding binary resource
   */
  @Override
  public byte[] getResource() {
    return resource;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableForm(
        value,
        this.formId,
        this.version,
        this.formKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#getFormId() formId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withFormId(String value) {
    if (Objects.equals(this.formId, value)) return this;
    return new ImmutableForm(
        this.tenantId,
        value,
        this.version,
        this.formKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableForm(
        this.tenantId,
        this.formId,
        value,
        this.formKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#getFormKey() formKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for formKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withFormKey(long value) {
    if (this.formKey == value) return this;
    return new ImmutableForm(
        this.tenantId,
        this.formId,
        this.version,
        value,
        this.resourceName,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#getResourceName() resourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withResourceName(String value) {
    if (Objects.equals(this.resourceName, value)) return this;
    return new ImmutableForm(
        this.tenantId,
        this.formId,
        this.version,
        this.formKey,
        value,
        this.checksum,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form#getChecksum() checksum}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for checksum
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForm withChecksum(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableForm(
        this.tenantId,
        this.formId,
        this.version,
        this.formKey,
        this.resourceName,
        newValue,
        this.duplicate,
        this.resource);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Form#isDuplicate() duplicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duplicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForm withDuplicate(boolean value) {
    if (this.duplicate == value) return this;
    return new ImmutableForm(
        this.tenantId,
        this.formId,
        this.version,
        this.formKey,
        this.resourceName,
        this.checksum,
        value,
        this.resource);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link Form#getResource() resource}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for resource
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForm withResource(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableForm(
        this.tenantId,
        this.formId,
        this.version,
        this.formKey,
        this.resourceName,
        this.checksum,
        this.duplicate,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableForm} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableForm
        && equalTo(0, (ImmutableForm) another);
  }

  private boolean equalTo(int synthetic, ImmutableForm another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && Objects.equals(formId, another.formId)
        && version == another.version
        && formKey == another.formKey
        && Objects.equals(resourceName, another.resourceName)
        && Arrays.equals(checksum, another.checksum)
        && duplicate == another.duplicate
        && Arrays.equals(resource, another.resource);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code formId}, {@code version}, {@code formKey}, {@code resourceName}, {@code checksum}, {@code duplicate}, {@code resource}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(formId);
    h += (h << 5) + version;
    h += (h << 5) + Long.hashCode(formKey);
    h += (h << 5) + Objects.hashCode(resourceName);
    h += (h << 5) + Arrays.hashCode(checksum);
    h += (h << 5) + Boolean.hashCode(duplicate);
    h += (h << 5) + Arrays.hashCode(resource);
    return h;
  }

  /**
   * Prints the immutable value {@code Form} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Form{"
        + "tenantId=" + tenantId
        + ", formId=" + formId
        + ", version=" + version
        + ", formKey=" + formKey
        + ", resourceName=" + resourceName
        + ", checksum=" + Arrays.toString(checksum)
        + ", duplicate=" + duplicate
        + ", resource=" + Arrays.toString(resource)
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link Form} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Form instance
   */
  public static ImmutableForm copyOf(Form instance) {
    if (instance instanceof ImmutableForm) {
      return (ImmutableForm) instance;
    }
    return ImmutableForm.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableForm ImmutableForm}.
   * <pre>
   * ImmutableForm.builder()
   *    .withTenantId(String | null) // nullable {@link Form#getTenantId() tenantId}
   *    .withFormId(String | null) // nullable {@link Form#getFormId() formId}
   *    .withVersion(int) // optional {@link Form#getVersion() version}
   *    .withFormKey(long) // optional {@link Form#getFormKey() formKey}
   *    .withResourceName(String | null) // nullable {@link Form#getResourceName() resourceName}
   *    .withChecksum(byte[] | null) // nullable {@link Form#getChecksum() checksum}
   *    .withDuplicate(boolean) // optional {@link Form#isDuplicate() duplicate}
   *    .withResource(byte[] | null) // nullable {@link Form#getResource() resource}
   *    .build();
   * </pre>
   * @return A new ImmutableForm builder
   */
  public static ImmutableForm.Builder builder() {
    return new ImmutableForm.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableForm ImmutableForm}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Form", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private String formId;
    private int version;
    private long formKey;
    private String resourceName;
    private byte[] checksum;
    private boolean duplicate;
    private byte[] resource;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.deployment.Form} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Form instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FormMetadataValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof Form) {
        Form instance = (Form) object;
        if ((bits & 0x1L) == 0) {
          String formIdValue = instance.getFormId();
          if (formIdValue != null) {
            withFormId(formIdValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          withFormKey(instance.getFormKey());
          bits |= 0x2L;
        }
        byte[] resourceValue = instance.getResource();
        if (resourceValue != null) {
          withResource(resourceValue);
        }
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          byte[] checksumValue = instance.getChecksum();
          if (checksumValue != null) {
            withChecksum(checksumValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          String resourceNameValue = instance.getResourceName();
          if (resourceNameValue != null) {
            withResourceName(resourceNameValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          withDuplicate(instance.isDuplicate());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          withVersion(instance.getVersion());
          bits |= 0x40L;
        }
      }
      if (object instanceof FormMetadataValue) {
        FormMetadataValue instance = (FormMetadataValue) object;
        if ((bits & 0x1L) == 0) {
          String formIdValue = instance.getFormId();
          if (formIdValue != null) {
            withFormId(formIdValue);
          }
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          withFormKey(instance.getFormKey());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          byte[] checksumValue = instance.getChecksum();
          if (checksumValue != null) {
            withChecksum(checksumValue);
          }
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          String resourceNameValue = instance.getResourceName();
          if (resourceNameValue != null) {
            withResourceName(resourceNameValue);
          }
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          withDuplicate(instance.isDuplicate());
          bits |= 0x20L;
        }
        if ((bits & 0x40L) == 0) {
          withVersion(instance.getVersion());
          bits |= 0x40L;
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x4L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x4L;
        }
      }
    }

    /**
     * Initializes the value for the {@link Form#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getFormId() formId} attribute.
     * @param formId The value for formId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFormId(String formId) {
      this.formId = formId;
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getFormKey() formKey} attribute.
     * @param formKey The value for formKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFormKey(long formKey) {
      this.formKey = formKey;
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getResourceName() resourceName} attribute.
     * @param resourceName The value for resourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getChecksum() checksum} attribute.
     * @param checksum The elements for checksum
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withChecksum(byte... checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link Form#isDuplicate() duplicate} attribute.
     * @param duplicate The value for duplicate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDuplicate(boolean duplicate) {
      this.duplicate = duplicate;
      return this;
    }

    /**
     * Initializes the value for the {@link Form#getResource() resource} attribute.
     * @param resource The elements for resource
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResource(byte... resource) {
      this.resource = resource;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.formId = null;
      this.version = 0;
      this.formKey = 0;
      this.resourceName = null;
      this.checksum = null;
      this.duplicate = false;
      this.resource = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableForm ImmutableForm}.
     * @return An immutable instance of Form
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableForm build() {
      return new ImmutableForm(tenantId, formId, version, formKey, resourceName, checksum, duplicate, resource);
    }



  }



}
