/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import io.camunda.zeebe.protocol.record.value.deployment.Form;
import io.camunda.zeebe.protocol.record.value.deployment.FormMetadataValue;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="Form", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableForm
implements Form {
    private final String tenantId;
    private final String formId;
    private final int version;
    private final long formKey;
    private final String resourceName;
    private final byte[] checksum;
    private final boolean duplicate;
    private final byte[] resource;
    private transient int hashCode;

    private ImmutableForm(String tenantId, String formId, int version, long formKey, String resourceName, byte[] checksum, boolean duplicate, byte[] resource) {
        this.tenantId = tenantId;
        this.formId = formId;
        this.version = version;
        this.formKey = formKey;
        this.resourceName = resourceName;
        this.checksum = checksum;
        this.duplicate = duplicate;
        this.resource = resource;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getFormId() {
        return this.formId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getFormKey() {
        return this.formKey;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public byte[] getChecksum() {
        return this.checksum;
    }

    @Override
    public boolean isDuplicate() {
        return this.duplicate;
    }

    @Override
    public byte[] getResource() {
        return this.resource;
    }

    public final ImmutableForm withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableForm(value, this.formId, this.version, this.formKey, this.resourceName, this.checksum, this.duplicate, this.resource);
    }

    public final ImmutableForm withFormId(String value) {
        if (Objects.equals(this.formId, value)) {
            return this;
        }
        return new ImmutableForm(this.tenantId, value, this.version, this.formKey, this.resourceName, this.checksum, this.duplicate, this.resource);
    }

    public final ImmutableForm withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableForm(this.tenantId, this.formId, value, this.formKey, this.resourceName, this.checksum, this.duplicate, this.resource);
    }

    public final ImmutableForm withFormKey(long value) {
        if (this.formKey == value) {
            return this;
        }
        return new ImmutableForm(this.tenantId, this.formId, this.version, value, this.resourceName, this.checksum, this.duplicate, this.resource);
    }

    public final ImmutableForm withResourceName(String value) {
        if (Objects.equals(this.resourceName, value)) {
            return this;
        }
        return new ImmutableForm(this.tenantId, this.formId, this.version, this.formKey, value, this.checksum, this.duplicate, this.resource);
    }

    public final ImmutableForm withChecksum(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableForm(this.tenantId, this.formId, this.version, this.formKey, this.resourceName, newValue, this.duplicate, this.resource);
    }

    public final ImmutableForm withDuplicate(boolean value) {
        if (this.duplicate == value) {
            return this;
        }
        return new ImmutableForm(this.tenantId, this.formId, this.version, this.formKey, this.resourceName, this.checksum, value, this.resource);
    }

    public final ImmutableForm withResource(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableForm(this.tenantId, this.formId, this.version, this.formKey, this.resourceName, this.checksum, this.duplicate, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableForm && this.equalTo(0, (ImmutableForm)another);
    }

    private boolean equalTo(int synthetic, ImmutableForm another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.tenantId, another.tenantId) && Objects.equals(this.formId, another.formId) && this.version == another.version && this.formKey == another.formKey && Objects.equals(this.resourceName, another.resourceName) && Arrays.equals(this.checksum, another.checksum) && this.duplicate == another.duplicate && Arrays.equals(this.resource, another.resource);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.tenantId);
        h += (h << 5) + Objects.hashCode(this.formId);
        h += (h << 5) + this.version;
        h += (h << 5) + Long.hashCode(this.formKey);
        h += (h << 5) + Objects.hashCode(this.resourceName);
        h += (h << 5) + Arrays.hashCode(this.checksum);
        h += (h << 5) + Boolean.hashCode(this.duplicate);
        h += (h << 5) + Arrays.hashCode(this.resource);
        return h;
    }

    public String toString() {
        return "Form{tenantId=" + this.tenantId + ", formId=" + this.formId + ", version=" + this.version + ", formKey=" + this.formKey + ", resourceName=" + this.resourceName + ", checksum=" + Arrays.toString(this.checksum) + ", duplicate=" + this.duplicate + ", resource=" + Arrays.toString(this.resource) + "}";
    }

    public static ImmutableForm copyOf(Form instance) {
        if (instance instanceof ImmutableForm) {
            return (ImmutableForm)instance;
        }
        return ImmutableForm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="Form", generator="Immutables")
    public static final class Builder {
        private String tenantId;
        private String formId;
        private int version;
        private long formKey;
        private String resourceName;
        private byte[] checksum;
        private boolean duplicate;
        private byte[] resource;

        private Builder() {
        }

        public final Builder from(Form instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(FormMetadataValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String tenantIdValue;
            String formIdValue;
            TenantOwned instance;
            long bits = 0L;
            if (object instanceof Form) {
                byte[] resourceValue;
                instance = (Form)object;
                if ((bits & 1L) == 0L) {
                    formIdValue = instance.getFormId();
                    if (formIdValue != null) {
                        this.withFormId(formIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.withFormKey(instance.getFormKey());
                    bits |= 2L;
                }
                if ((resourceValue = instance.getResource()) != null) {
                    this.withResource(resourceValue);
                }
                if ((bits & 4L) == 0L) {
                    String tenantIdValue2 = instance.getTenantId();
                    if (tenantIdValue2 != null) {
                        this.withTenantId(tenantIdValue2);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    byte[] checksumValue = instance.getChecksum();
                    if (checksumValue != null) {
                        this.withChecksum(checksumValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    String resourceNameValue = instance.getResourceName();
                    if (resourceNameValue != null) {
                        this.withResourceName(resourceNameValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.withDuplicate(instance.isDuplicate());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.withVersion(instance.getVersion());
                    bits |= 0x40L;
                }
            }
            if (object instanceof FormMetadataValue) {
                instance = (FormMetadataValue)object;
                if ((bits & 1L) == 0L) {
                    formIdValue = instance.getFormId();
                    if (formIdValue != null) {
                        this.withFormId(formIdValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.withFormKey(instance.getFormKey());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    byte[] checksumValue = instance.getChecksum();
                    if (checksumValue != null) {
                        this.withChecksum(checksumValue);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    String resourceNameValue = instance.getResourceName();
                    if (resourceNameValue != null) {
                        this.withResourceName(resourceNameValue);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.withDuplicate(instance.isDuplicate());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.withVersion(instance.getVersion());
                    bits |= 0x40L;
                }
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 4L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
            }
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withFormId(String formId) {
            this.formId = formId;
            return this;
        }

        public final Builder withVersion(int version) {
            this.version = version;
            return this;
        }

        public final Builder withFormKey(long formKey) {
            this.formKey = formKey;
            return this;
        }

        public final Builder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final Builder withChecksum(byte ... checksum) {
            this.checksum = checksum;
            return this;
        }

        public final Builder withDuplicate(boolean duplicate) {
            this.duplicate = duplicate;
            return this;
        }

        public final Builder withResource(byte ... resource) {
            this.resource = resource;
            return this;
        }

        public Builder clear() {
            this.tenantId = null;
            this.formId = null;
            this.version = 0;
            this.formKey = 0L;
            this.resourceName = null;
            this.checksum = null;
            this.duplicate = false;
            this.resource = null;
            return this;
        }

        public ImmutableForm build() {
            return new ImmutableForm(this.tenantId, this.formId, this.version, this.formKey, this.resourceName, this.checksum, this.duplicate, this.resource);
        }
    }
}

