package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MatchedRuleValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMatchedRuleValue.builder()}.
 */
@Generated(from = "MatchedRuleValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableMatchedRuleValue.Builder.class)
public final class ImmutableMatchedRuleValue
    implements MatchedRuleValue {
  private final String ruleId;
  private final int ruleIndex;
  private final List<EvaluatedOutputValue> evaluatedOutputs;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableMatchedRuleValue(
      String ruleId,
      int ruleIndex,
      List<EvaluatedOutputValue> evaluatedOutputs) {
    this.ruleId = ruleId;
    this.ruleIndex = ruleIndex;
    this.evaluatedOutputs = evaluatedOutputs;
  }

  /**
   * @return the id of the matched rule
   */
  @Override
  public String getRuleId() {
    return ruleId;
  }

  /**
   * Returns the index of the matched rule in the decision table, starting with 1.
   * @return the index of the matched rule
   */
  @Override
  public int getRuleIndex() {
    return ruleIndex;
  }

  /**
   * @return the evaluated outputs of the rule
   */
  @Override
  public List<EvaluatedOutputValue> getEvaluatedOutputs() {
    return evaluatedOutputs;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MatchedRuleValue#getRuleId() ruleId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ruleId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMatchedRuleValue withRuleId(String value) {
    if (Objects.equals(this.ruleId, value)) return this;
    return new ImmutableMatchedRuleValue(value, this.ruleIndex, this.evaluatedOutputs);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MatchedRuleValue#getRuleIndex() ruleIndex} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ruleIndex
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMatchedRuleValue withRuleIndex(int value) {
    if (this.ruleIndex == value) return this;
    return new ImmutableMatchedRuleValue(this.ruleId, value, this.evaluatedOutputs);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedRuleValue withEvaluatedOutputs(EvaluatedOutputValue... elements) {
    List<EvaluatedOutputValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableMatchedRuleValue(this.ruleId, this.ruleIndex, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of evaluatedOutputs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMatchedRuleValue withEvaluatedOutputs(Iterable<? extends EvaluatedOutputValue> elements) {
    if (this.evaluatedOutputs == elements) return this;
    List<EvaluatedOutputValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableMatchedRuleValue(this.ruleId, this.ruleIndex, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMatchedRuleValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMatchedRuleValue
        && equalTo(0, (ImmutableMatchedRuleValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableMatchedRuleValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(ruleId, another.ruleId)
        && ruleIndex == another.ruleIndex
        && evaluatedOutputs.equals(another.evaluatedOutputs);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code ruleId}, {@code ruleIndex}, {@code evaluatedOutputs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(ruleId);
    h += (h << 5) + ruleIndex;
    h += (h << 5) + evaluatedOutputs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MatchedRuleValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MatchedRuleValue{"
        + "ruleId=" + ruleId
        + ", ruleIndex=" + ruleIndex
        + ", evaluatedOutputs=" + evaluatedOutputs
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MatchedRuleValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MatchedRuleValue instance
   */
  public static ImmutableMatchedRuleValue copyOf(MatchedRuleValue instance) {
    if (instance instanceof ImmutableMatchedRuleValue) {
      return (ImmutableMatchedRuleValue) instance;
    }
    return ImmutableMatchedRuleValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMatchedRuleValue ImmutableMatchedRuleValue}.
   * <pre>
   * ImmutableMatchedRuleValue.builder()
   *    .withRuleId(String | null) // nullable {@link MatchedRuleValue#getRuleId() ruleId}
   *    .withRuleIndex(int) // optional {@link MatchedRuleValue#getRuleIndex() ruleIndex}
   *    .addEvaluatedOutput|addAllEvaluatedOutputs(io.camunda.zeebe.protocol.record.value.EvaluatedOutputValue) // {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs} elements
   *    .build();
   * </pre>
   * @return A new ImmutableMatchedRuleValue builder
   */
  public static ImmutableMatchedRuleValue.Builder builder() {
    return new ImmutableMatchedRuleValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMatchedRuleValue ImmutableMatchedRuleValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MatchedRuleValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String ruleId;
    private int ruleIndex;
    private List<ImmutableEvaluatedOutputValue.Builder> evaluatedOutputs = new ArrayList<ImmutableEvaluatedOutputValue.Builder>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MatchedRuleValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MatchedRuleValue instance) {
      Objects.requireNonNull(instance, "instance");
      String ruleIdValue = instance.getRuleId();
      if (ruleIdValue != null) {
        withRuleId(ruleIdValue);
      }
      withRuleIndex(instance.getRuleIndex());
      addAllEvaluatedOutputs(instance.getEvaluatedOutputs());
      return this;
    }

    /**
     * Initializes the value for the {@link MatchedRuleValue#getRuleId() ruleId} attribute.
     * @param ruleId The value for ruleId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withRuleId(String ruleId) {
      this.ruleId = ruleId;
      return this;
    }

    /**
     * Initializes the value for the {@link MatchedRuleValue#getRuleIndex() ruleIndex} attribute.
     * @param ruleIndex The value for ruleIndex 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withRuleIndex(int ruleIndex) {
      this.ruleIndex = ruleIndex;
      return this;
    }

    /**
     * Adds one element to {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs} list.
     * @param element A evaluatedOutputs element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEvaluatedOutput(EvaluatedOutputValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(element);
      this.evaluatedOutputs.add(ImmutableEvaluatedOutputValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs} list.
     * @param elements An array of evaluatedOutputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addEvaluatedOutputs(EvaluatedOutputValue... elements) {
      for (EvaluatedOutputValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(element);
        this.evaluatedOutputs.add(ImmutableEvaluatedOutputValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs} list and returns
     * the builder.
     */
    public final ImmutableEvaluatedOutputValue.Builder addEvaluatedOutputBuilder() {
      ImmutableEvaluatedOutputValue.Builder builder = ImmutableEvaluatedOutputValue.builder();
      this.evaluatedOutputs.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs} list.
     * @param elements An array of evaluatedOutputs builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvaluatedOutputBuilders(ImmutableEvaluatedOutputValue.Builder... elements) {
      for (ImmutableEvaluatedOutputValue.Builder element : elements) {
        this.evaluatedOutputs.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableEvaluatedOutputValue.Builder> evaluatedOutputBuilders() {
      return createUnmodifiableList(false, this.evaluatedOutputs);
    }

    /**
     * Sets or replaces all elements for {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs} list.
     * @param elements An iterable of evaluatedOutputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withEvaluatedOutputs(Iterable<? extends EvaluatedOutputValue> elements) {
      this.evaluatedOutputs.clear();
      return addAllEvaluatedOutputs(elements);
    }

    /**
     * Adds elements to {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs} list.
     * @param elements An iterable of evaluatedOutputs elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvaluatedOutputs(Iterable<? extends EvaluatedOutputValue> elements) {
      for (EvaluatedOutputValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(element);
        this.evaluatedOutputs.add(ImmutableEvaluatedOutputValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link MatchedRuleValue#getEvaluatedOutputs() evaluatedOutputs} list.
     * @param elements An iterable of evaluatedOutputs builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEvaluatedOutputBuilders(Iterable<ImmutableEvaluatedOutputValue.Builder> elements) {
      for (ImmutableEvaluatedOutputValue.Builder element : elements) {
        this.evaluatedOutputs.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.ruleId = null;
      this.ruleIndex = 0;
      this.evaluatedOutputs.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableMatchedRuleValue ImmutableMatchedRuleValue}.
     * @return An immutable instance of MatchedRuleValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMatchedRuleValue build() {
      return new ImmutableMatchedRuleValue(
          ruleId,
          ruleIndex,
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(evaluatedOutputs)));
    }



    
    private static ImmutableEvaluatedOutputValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue( ImmutableEvaluatedOutputValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    
    private static EvaluatedOutputValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue( EvaluatedOutputValue value) {
      if (value == null) return null;
      return ImmutableEvaluatedOutputValue.builder().from(value).build();
    }

    
    private static ImmutableEvaluatedOutputValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue( EvaluatedOutputValue value) {
      if (value == null) return null;
      return ImmutableEvaluatedOutputValue.builder().from(value);
    }

    private static List<EvaluatedOutputValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(Iterable<? extends ImmutableEvaluatedOutputValue.Builder> builderList) {
      ArrayList<EvaluatedOutputValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
        list = new ArrayList<>(size);
      } else {
        list = new ArrayList<>();
      }
      for (ImmutableEvaluatedOutputValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<EvaluatedOutputValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(ImmutableEvaluatedOutputValue.Builder... builderArray) {
      ArrayList<EvaluatedOutputValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>(builderArray.length);
      for (ImmutableEvaluatedOutputValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableEvaluatedOutputValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(Iterable<? extends ImmutableEvaluatedOutputValue> valueList) {
      ArrayList<ImmutableEvaluatedOutputValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
        list = new ArrayList<>(size);
      } else {
        list = new ArrayList<>();
      }
      for (ImmutableEvaluatedOutputValue element : valueList) {
        list.add(ImmutableEvaluatedOutputValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableEvaluatedOutputValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(ImmutableEvaluatedOutputValue... valueArray) {
      ArrayList<ImmutableEvaluatedOutputValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>(valueArray.length);
      for (ImmutableEvaluatedOutputValue element : valueArray) {
        list.add(ImmutableEvaluatedOutputValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }



  
  private static ImmutableEvaluatedOutputValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue( ImmutableEvaluatedOutputValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  
  private static EvaluatedOutputValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue( EvaluatedOutputValue value) {
    if (value == null) return null;
    return ImmutableEvaluatedOutputValue.builder().from(value).build();
  }

  
  private static ImmutableEvaluatedOutputValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue( EvaluatedOutputValue value) {
    if (value == null) return null;
    return ImmutableEvaluatedOutputValue.builder().from(value);
  }

  private static List<EvaluatedOutputValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(Iterable<? extends ImmutableEvaluatedOutputValue.Builder> builderList) {
    ArrayList<EvaluatedOutputValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (ImmutableEvaluatedOutputValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<EvaluatedOutputValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(ImmutableEvaluatedOutputValue.Builder... builderArray) {
    ArrayList<EvaluatedOutputValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>(builderArray.length);
    for (ImmutableEvaluatedOutputValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableEvaluatedOutputValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(Iterable<? extends ImmutableEvaluatedOutputValue> valueList) {
    ArrayList<ImmutableEvaluatedOutputValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (ImmutableEvaluatedOutputValue element : valueList) {
      list.add(ImmutableEvaluatedOutputValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableEvaluatedOutputValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableEvaluatedOutputValue(ImmutableEvaluatedOutputValue... valueArray) {
    ArrayList<ImmutableEvaluatedOutputValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>(valueArray.length);
    for (ImmutableEvaluatedOutputValue element : valueArray) {
      list.add(ImmutableEvaluatedOutputValue.builder().from(element));
    }
    return list;
  }
}
