package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceRecordValue.builder()}.
 */
@Generated(from = "ProcessInstanceRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceRecordValue.Builder.class)
public final class ImmutableProcessInstanceRecordValue
    implements ProcessInstanceRecordValue {
  private final String tenantId;
  private final String bpmnProcessId;
  private final int version;
  private final long processDefinitionKey;
  private final long processInstanceKey;
  private final String elementId;
  private final long flowScopeKey;
  private final BpmnElementType bpmnElementType;
  private final long parentProcessInstanceKey;
  private final long parentElementInstanceKey;
  private final BpmnEventType bpmnEventType;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceRecordValue(
      String tenantId,
      String bpmnProcessId,
      int version,
      long processDefinitionKey,
      long processInstanceKey,
      String elementId,
      long flowScopeKey,
      BpmnElementType bpmnElementType,
      long parentProcessInstanceKey,
      long parentElementInstanceKey,
      BpmnEventType bpmnEventType) {
    this.tenantId = tenantId;
    this.bpmnProcessId = bpmnProcessId;
    this.version = version;
    this.processDefinitionKey = processDefinitionKey;
    this.processInstanceKey = processInstanceKey;
    this.elementId = elementId;
    this.flowScopeKey = flowScopeKey;
    this.bpmnElementType = bpmnElementType;
    this.parentProcessInstanceKey = parentProcessInstanceKey;
    this.parentElementInstanceKey = parentElementInstanceKey;
    this.bpmnEventType = bpmnEventType;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the BPMN process id this process instance belongs to.
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the version of the deployed process this instance belongs to.
   */
  @Override
  public int getVersion() {
    return version;
  }

  /**
   * @return the key of the deployed process this instance belongs to.
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the key of the process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the id of the current process element, or empty if the id is not specified.
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * @return the key of the activity instance that is the flow scope of this flow element instance;
   *     -1 for records of the process instance itself.
   */
  @Override
  public long getFlowScopeKey() {
    return flowScopeKey;
  }

  /**
   * @return the BPMN type of the current process element.
   */
  @Override
  public BpmnElementType getBpmnElementType() {
    return bpmnElementType;
  }

  /**
   * @return the key of the process instance that created this instance, or -1 if it was not created
   *     by another process instance.
   */
  @Override
  public long getParentProcessInstanceKey() {
    return parentProcessInstanceKey;
  }

  /**
   * @return the key of the element instance that created this instance, or -1 if it was not created
   *     by another process instance.
   */
  @Override
  public long getParentElementInstanceKey() {
    return parentElementInstanceKey;
  }

  /**
   * @return the BPMN event type of the current process element.
   */
  @Override
  public BpmnEventType getBpmnEventType() {
    return bpmnEventType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableProcessInstanceRecordValue(
        value,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.flowScopeKey,
        this.bpmnElementType,
        this.parentProcessInstanceKey,
        this.parentElementInstanceKey,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        value,
        this.version,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.flowScopeKey,
        this.bpmnElementType,
        this.parentProcessInstanceKey,
        this.parentElementInstanceKey,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        this.bpmnProcessId,
        value,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.flowScopeKey,
        this.bpmnElementType,
        this.parentProcessInstanceKey,
        this.parentElementInstanceKey,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        value,
        this.processInstanceKey,
        this.elementId,
        this.flowScopeKey,
        this.bpmnElementType,
        this.parentProcessInstanceKey,
        this.parentElementInstanceKey,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        value,
        this.elementId,
        this.flowScopeKey,
        this.bpmnElementType,
        this.parentProcessInstanceKey,
        this.parentElementInstanceKey,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.processInstanceKey,
        value,
        this.flowScopeKey,
        this.bpmnElementType,
        this.parentProcessInstanceKey,
        this.parentElementInstanceKey,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getFlowScopeKey() flowScopeKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for flowScopeKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withFlowScopeKey(long value) {
    if (this.flowScopeKey == value) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        value,
        this.bpmnElementType,
        this.parentProcessInstanceKey,
        this.parentElementInstanceKey,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getBpmnElementType() bpmnElementType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnElementType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withBpmnElementType(BpmnElementType value) {
    if (this.bpmnElementType == value) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.flowScopeKey,
        value,
        this.parentProcessInstanceKey,
        this.parentElementInstanceKey,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getParentProcessInstanceKey() parentProcessInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentProcessInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withParentProcessInstanceKey(long value) {
    if (this.parentProcessInstanceKey == value) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.flowScopeKey,
        this.bpmnElementType,
        value,
        this.parentElementInstanceKey,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getParentElementInstanceKey() parentElementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for parentElementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withParentElementInstanceKey(long value) {
    if (this.parentElementInstanceKey == value) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.flowScopeKey,
        this.bpmnElementType,
        this.parentProcessInstanceKey,
        value,
        this.bpmnEventType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceRecordValue#getBpmnEventType() bpmnEventType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnEventType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceRecordValue withBpmnEventType(BpmnEventType value) {
    if (this.bpmnEventType == value) return this;
    return new ImmutableProcessInstanceRecordValue(
        this.tenantId,
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.processInstanceKey,
        this.elementId,
        this.flowScopeKey,
        this.bpmnElementType,
        this.parentProcessInstanceKey,
        this.parentElementInstanceKey,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceRecordValue
        && equalTo(0, (ImmutableProcessInstanceRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && version == another.version
        && processDefinitionKey == another.processDefinitionKey
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(elementId, another.elementId)
        && flowScopeKey == another.flowScopeKey
        && Objects.equals(bpmnElementType, another.bpmnElementType)
        && parentProcessInstanceKey == another.parentProcessInstanceKey
        && parentElementInstanceKey == another.parentElementInstanceKey
        && Objects.equals(bpmnEventType, another.bpmnEventType);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code bpmnProcessId}, {@code version}, {@code processDefinitionKey}, {@code processInstanceKey}, {@code elementId}, {@code flowScopeKey}, {@code bpmnElementType}, {@code parentProcessInstanceKey}, {@code parentElementInstanceKey}, {@code bpmnEventType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + version;
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(elementId);
    h += (h << 5) + Long.hashCode(flowScopeKey);
    h += (h << 5) + Objects.hashCode(bpmnElementType);
    h += (h << 5) + Long.hashCode(parentProcessInstanceKey);
    h += (h << 5) + Long.hashCode(parentElementInstanceKey);
    h += (h << 5) + Objects.hashCode(bpmnEventType);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceRecordValue{"
        + "tenantId=" + tenantId
        + ", bpmnProcessId=" + bpmnProcessId
        + ", version=" + version
        + ", processDefinitionKey=" + processDefinitionKey
        + ", processInstanceKey=" + processInstanceKey
        + ", elementId=" + elementId
        + ", flowScopeKey=" + flowScopeKey
        + ", bpmnElementType=" + bpmnElementType
        + ", parentProcessInstanceKey=" + parentProcessInstanceKey
        + ", parentElementInstanceKey=" + parentElementInstanceKey
        + ", bpmnEventType=" + bpmnEventType
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceRecordValue instance
   */
  public static ImmutableProcessInstanceRecordValue copyOf(ProcessInstanceRecordValue instance) {
    if (instance instanceof ImmutableProcessInstanceRecordValue) {
      return (ImmutableProcessInstanceRecordValue) instance;
    }
    return ImmutableProcessInstanceRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceRecordValue ImmutableProcessInstanceRecordValue}.
   * <pre>
   * ImmutableProcessInstanceRecordValue.builder()
   *    .withTenantId(String | null) // nullable {@link ProcessInstanceRecordValue#getTenantId() tenantId}
   *    .withBpmnProcessId(String | null) // nullable {@link ProcessInstanceRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withVersion(int) // optional {@link ProcessInstanceRecordValue#getVersion() version}
   *    .withProcessDefinitionKey(long) // optional {@link ProcessInstanceRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withProcessInstanceKey(long) // optional {@link ProcessInstanceRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withElementId(String | null) // nullable {@link ProcessInstanceRecordValue#getElementId() elementId}
   *    .withFlowScopeKey(long) // optional {@link ProcessInstanceRecordValue#getFlowScopeKey() flowScopeKey}
   *    .withBpmnElementType(io.camunda.zeebe.protocol.record.value.BpmnElementType | null) // nullable {@link ProcessInstanceRecordValue#getBpmnElementType() bpmnElementType}
   *    .withParentProcessInstanceKey(long) // optional {@link ProcessInstanceRecordValue#getParentProcessInstanceKey() parentProcessInstanceKey}
   *    .withParentElementInstanceKey(long) // optional {@link ProcessInstanceRecordValue#getParentElementInstanceKey() parentElementInstanceKey}
   *    .withBpmnEventType(io.camunda.zeebe.protocol.record.value.BpmnEventType | null) // nullable {@link ProcessInstanceRecordValue#getBpmnEventType() bpmnEventType}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceRecordValue builder
   */
  public static ImmutableProcessInstanceRecordValue.Builder builder() {
    return new ImmutableProcessInstanceRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceRecordValue ImmutableProcessInstanceRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private String bpmnProcessId;
    private int version;
    private long processDefinitionKey;
    private long processInstanceKey;
    private String elementId;
    private long flowScopeKey;
    private BpmnElementType bpmnElementType;
    private long parentProcessInstanceKey;
    private long parentElementInstanceKey;
    private BpmnEventType bpmnEventType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof ProcessInstanceRecordValue) {
        ProcessInstanceRecordValue instance = (ProcessInstanceRecordValue) object;
        String elementIdValue = instance.getElementId();
        if (elementIdValue != null) {
          withElementId(elementIdValue);
        }
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        withFlowScopeKey(instance.getFlowScopeKey());
        BpmnEventType bpmnEventTypeValue = instance.getBpmnEventType();
        if (bpmnEventTypeValue != null) {
          withBpmnEventType(bpmnEventTypeValue);
        }
        withParentElementInstanceKey(instance.getParentElementInstanceKey());
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        withVersion(instance.getVersion());
        BpmnElementType bpmnElementTypeValue = instance.getBpmnElementType();
        if (bpmnElementTypeValue != null) {
          withBpmnElementType(bpmnElementTypeValue);
        }
        withParentProcessInstanceKey(instance.getParentProcessInstanceKey());
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getFlowScopeKey() flowScopeKey} attribute.
     * @param flowScopeKey The value for flowScopeKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withFlowScopeKey(long flowScopeKey) {
      this.flowScopeKey = flowScopeKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getBpmnElementType() bpmnElementType} attribute.
     * @param bpmnElementType The value for bpmnElementType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnElementType(BpmnElementType bpmnElementType) {
      this.bpmnElementType = bpmnElementType;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getParentProcessInstanceKey() parentProcessInstanceKey} attribute.
     * @param parentProcessInstanceKey The value for parentProcessInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withParentProcessInstanceKey(long parentProcessInstanceKey) {
      this.parentProcessInstanceKey = parentProcessInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getParentElementInstanceKey() parentElementInstanceKey} attribute.
     * @param parentElementInstanceKey The value for parentElementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withParentElementInstanceKey(long parentElementInstanceKey) {
      this.parentElementInstanceKey = parentElementInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceRecordValue#getBpmnEventType() bpmnEventType} attribute.
     * @param bpmnEventType The value for bpmnEventType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnEventType(BpmnEventType bpmnEventType) {
      this.bpmnEventType = bpmnEventType;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.bpmnProcessId = null;
      this.version = 0;
      this.processDefinitionKey = 0;
      this.processInstanceKey = 0;
      this.elementId = null;
      this.flowScopeKey = 0;
      this.bpmnElementType = null;
      this.parentProcessInstanceKey = 0;
      this.parentElementInstanceKey = 0;
      this.bpmnEventType = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceRecordValue ImmutableProcessInstanceRecordValue}.
     * @return An immutable instance of ProcessInstanceRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceRecordValue build() {
      return new ImmutableProcessInstanceRecordValue(
          tenantId,
          bpmnProcessId,
          version,
          processDefinitionKey,
          processInstanceKey,
          elementId,
          flowScopeKey,
          bpmnElementType,
          parentProcessInstanceKey,
          parentElementInstanceKey,
          bpmnEventType);
    }



  }



}
