package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ResourceDeletionRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableResourceDeletionRecordValue.builder()}.
 */
@Generated(from = "ResourceDeletionRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableResourceDeletionRecordValue.Builder.class)
public final class ImmutableResourceDeletionRecordValue
    implements ResourceDeletionRecordValue {
  private final String tenantId;
  private final long resourceKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableResourceDeletionRecordValue(String tenantId, long resourceKey) {
    this.tenantId = tenantId;
    this.resourceKey = resourceKey;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the key of the resource that will be deleted
   */
  @Override
  public long getResourceKey() {
    return resourceKey;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ResourceDeletionRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResourceDeletionRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableResourceDeletionRecordValue(value, this.resourceKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ResourceDeletionRecordValue#getResourceKey() resourceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableResourceDeletionRecordValue withResourceKey(long value) {
    if (this.resourceKey == value) return this;
    return new ImmutableResourceDeletionRecordValue(this.tenantId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableResourceDeletionRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableResourceDeletionRecordValue
        && equalTo(0, (ImmutableResourceDeletionRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableResourceDeletionRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && resourceKey == another.resourceKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code resourceKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(resourceKey);
    return h;
  }

  /**
   * Prints the immutable value {@code ResourceDeletionRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ResourceDeletionRecordValue{"
        + "tenantId=" + tenantId
        + ", resourceKey=" + resourceKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ResourceDeletionRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ResourceDeletionRecordValue instance
   */
  public static ImmutableResourceDeletionRecordValue copyOf(ResourceDeletionRecordValue instance) {
    if (instance instanceof ImmutableResourceDeletionRecordValue) {
      return (ImmutableResourceDeletionRecordValue) instance;
    }
    return ImmutableResourceDeletionRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableResourceDeletionRecordValue ImmutableResourceDeletionRecordValue}.
   * <pre>
   * ImmutableResourceDeletionRecordValue.builder()
   *    .withTenantId(String | null) // nullable {@link ResourceDeletionRecordValue#getTenantId() tenantId}
   *    .withResourceKey(long) // optional {@link ResourceDeletionRecordValue#getResourceKey() resourceKey}
   *    .build();
   * </pre>
   * @return A new ImmutableResourceDeletionRecordValue builder
   */
  public static ImmutableResourceDeletionRecordValue.Builder builder() {
    return new ImmutableResourceDeletionRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableResourceDeletionRecordValue ImmutableResourceDeletionRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ResourceDeletionRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private long resourceKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ResourceDeletionRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ResourceDeletionRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof ResourceDeletionRecordValue) {
        ResourceDeletionRecordValue instance = (ResourceDeletionRecordValue) object;
        withResourceKey(instance.getResourceKey());
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ResourceDeletionRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link ResourceDeletionRecordValue#getResourceKey() resourceKey} attribute.
     * @param resourceKey The value for resourceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceKey(long resourceKey) {
      this.resourceKey = resourceKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.resourceKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableResourceDeletionRecordValue ImmutableResourceDeletionRecordValue}.
     * @return An immutable instance of ResourceDeletionRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableResourceDeletionRecordValue build() {
      return new ImmutableResourceDeletionRecordValue(tenantId, resourceKey);
    }



  }



}
