package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link VariableRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVariableRecordValue.builder()}.
 */
@Generated(from = "VariableRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableVariableRecordValue.Builder.class)
public final class ImmutableVariableRecordValue
    implements VariableRecordValue {
  private final String tenantId;
  private final String name;
  private final String value;
  private final long scopeKey;
  private final long processInstanceKey;
  private final long processDefinitionKey;
  private final String bpmnProcessId;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableVariableRecordValue(
      String tenantId,
      String name,
      String value,
      long scopeKey,
      long processInstanceKey,
      long processDefinitionKey,
      String bpmnProcessId) {
    this.tenantId = tenantId;
    this.name = name;
    this.value = value;
    this.scopeKey = scopeKey;
    this.processInstanceKey = processInstanceKey;
    this.processDefinitionKey = processDefinitionKey;
    this.bpmnProcessId = bpmnProcessId;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the name of the variable.
   */
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return the value of the variable as JSON string.
   */
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return the key of the scope the variable belongs to.
   */
  @Override
  public long getScopeKey() {
    return scopeKey;
  }

  /**
   * @return the key of the process instance the variable belongs to
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the key of the process the variable belongs to
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the BPMN process id this process instance belongs to.
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableVariableRecordValue(
        value,
        this.name,
        this.value,
        this.scopeKey,
        this.processInstanceKey,
        this.processDefinitionKey,
        this.bpmnProcessId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableRecordValue#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableRecordValue withName(String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableVariableRecordValue(
        this.tenantId,
        value,
        this.value,
        this.scopeKey,
        this.processInstanceKey,
        this.processDefinitionKey,
        this.bpmnProcessId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableRecordValue#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableRecordValue withValue(String value) {
    if (Objects.equals(this.value, value)) return this;
    return new ImmutableVariableRecordValue(
        this.tenantId,
        this.name,
        value,
        this.scopeKey,
        this.processInstanceKey,
        this.processDefinitionKey,
        this.bpmnProcessId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableRecordValue#getScopeKey() scopeKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for scopeKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableRecordValue withScopeKey(long value) {
    if (this.scopeKey == value) return this;
    return new ImmutableVariableRecordValue(
        this.tenantId,
        this.name,
        this.value,
        value,
        this.processInstanceKey,
        this.processDefinitionKey,
        this.bpmnProcessId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableVariableRecordValue(
        this.tenantId,
        this.name,
        this.value,
        this.scopeKey,
        value,
        this.processDefinitionKey,
        this.bpmnProcessId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableVariableRecordValue(
        this.tenantId,
        this.name,
        this.value,
        this.scopeKey,
        this.processInstanceKey,
        value,
        this.bpmnProcessId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VariableRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableVariableRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableVariableRecordValue(
        this.tenantId,
        this.name,
        this.value,
        this.scopeKey,
        this.processInstanceKey,
        this.processDefinitionKey,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVariableRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVariableRecordValue
        && equalTo(0, (ImmutableVariableRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableVariableRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && Objects.equals(name, another.name)
        && Objects.equals(value, another.value)
        && scopeKey == another.scopeKey
        && processInstanceKey == another.processInstanceKey
        && processDefinitionKey == another.processDefinitionKey
        && Objects.equals(bpmnProcessId, another.bpmnProcessId);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code name}, {@code value}, {@code scopeKey}, {@code processInstanceKey}, {@code processDefinitionKey}, {@code bpmnProcessId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(value);
    h += (h << 5) + Long.hashCode(scopeKey);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    return h;
  }

  /**
   * Prints the immutable value {@code VariableRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VariableRecordValue{"
        + "tenantId=" + tenantId
        + ", name=" + name
        + ", value=" + value
        + ", scopeKey=" + scopeKey
        + ", processInstanceKey=" + processInstanceKey
        + ", processDefinitionKey=" + processDefinitionKey
        + ", bpmnProcessId=" + bpmnProcessId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link VariableRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VariableRecordValue instance
   */
  public static ImmutableVariableRecordValue copyOf(VariableRecordValue instance) {
    if (instance instanceof ImmutableVariableRecordValue) {
      return (ImmutableVariableRecordValue) instance;
    }
    return ImmutableVariableRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVariableRecordValue ImmutableVariableRecordValue}.
   * <pre>
   * ImmutableVariableRecordValue.builder()
   *    .withTenantId(String | null) // nullable {@link VariableRecordValue#getTenantId() tenantId}
   *    .withName(String | null) // nullable {@link VariableRecordValue#getName() name}
   *    .withValue(String | null) // nullable {@link VariableRecordValue#getValue() value}
   *    .withScopeKey(long) // optional {@link VariableRecordValue#getScopeKey() scopeKey}
   *    .withProcessInstanceKey(long) // optional {@link VariableRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withProcessDefinitionKey(long) // optional {@link VariableRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withBpmnProcessId(String | null) // nullable {@link VariableRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .build();
   * </pre>
   * @return A new ImmutableVariableRecordValue builder
   */
  public static ImmutableVariableRecordValue.Builder builder() {
    return new ImmutableVariableRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVariableRecordValue ImmutableVariableRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VariableRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private String name;
    private String value;
    private long scopeKey;
    private long processInstanceKey;
    private long processDefinitionKey;
    private String bpmnProcessId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.VariableRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VariableRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
      }
      if (object instanceof VariableRecordValue) {
        VariableRecordValue instance = (VariableRecordValue) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x2L;
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          withName(nameValue);
        }
        withScopeKey(instance.getScopeKey());
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        String valueValue = instance.getValue();
        if (valueValue != null) {
          withValue(valueValue);
        }
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
      }
    }

    /**
     * Initializes the value for the {@link VariableRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableRecordValue#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withName(String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableRecordValue#getValue() value} attribute.
     * @param value The value for value (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withValue(String value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableRecordValue#getScopeKey() scopeKey} attribute.
     * @param scopeKey The value for scopeKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withScopeKey(long scopeKey) {
      this.scopeKey = scopeKey;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link VariableRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.name = null;
      this.value = null;
      this.scopeKey = 0;
      this.processInstanceKey = 0;
      this.processDefinitionKey = 0;
      this.bpmnProcessId = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableVariableRecordValue ImmutableVariableRecordValue}.
     * @return An immutable instance of VariableRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVariableRecordValue build() {
      return new ImmutableVariableRecordValue(tenantId, name, value, scopeKey, processInstanceKey, processDefinitionKey, bpmnProcessId);
    }



  }



}
