/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.retry;

import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.retry.OperationToRetry;
import java.util.function.BooleanSupplier;

public final class ActorRetryMechanism {
    private OperationToRetry currentCallable;
    private BooleanSupplier currentTerminateCondition;
    private ActorFuture<Boolean> currentFuture;

    void wrap(OperationToRetry callable, BooleanSupplier condition, ActorFuture<Boolean> resultFuture) {
        this.currentCallable = callable;
        this.currentTerminateCondition = condition;
        this.currentFuture = resultFuture;
    }

    Control run() throws Exception {
        if (this.currentCallable.run()) {
            this.currentFuture.complete(true);
            return Control.DONE;
        }
        if (this.currentTerminateCondition.getAsBoolean()) {
            this.currentFuture.complete(false);
            return Control.DONE;
        }
        return Control.RETRY;
    }

    static enum Control {
        RETRY,
        DONE;

    }
}

