/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.ActorJob;
import io.camunda.zeebe.scheduler.ActorMetrics;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.ActorThreadGroup;
import io.camunda.zeebe.scheduler.ActorTimerQueue;
import io.camunda.zeebe.scheduler.BoundedArrayQueue;
import io.camunda.zeebe.scheduler.TaskScheduler;
import io.camunda.zeebe.scheduler.TimerSubscription;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.DefaultActorClock;
import io.camunda.zeebe.util.Loggers;
import io.camunda.zeebe.util.error.FatalErrorHandler;
import io.prometheus.client.Histogram;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Consumer;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.ManyToManyConcurrentArrayQueue;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class ActorThread
extends Thread
implements Consumer<Runnable> {
    private static final Logger LOG = Loggers.ACTOR_LOGGER;
    private static final FatalErrorHandler FATAL_ERROR_HANDLER = FatalErrorHandler.withLogger((Logger)LOG);
    private static final VarHandle STATE_HANDLE;
    public final ManyToManyConcurrentArrayQueue<Runnable> submittedCallbacks = new ManyToManyConcurrentArrayQueue(24576);
    protected final ActorTimerQueue timerJobQueue;
    protected ActorTaskRunnerIdleStrategy idleStrategy;
    ActorTask currentTask;
    private final ActorMetrics actorMetrics;
    private final CompletableFuture<Void> terminationFuture = new CompletableFuture();
    private final ActorClock clock;
    private final int threadId;
    private final TaskScheduler taskScheduler;
    private final BoundedArrayQueue<ActorJob> jobs = new BoundedArrayQueue(2048);
    private final ActorThreadGroup actorThreadGroup;
    private volatile ActorThreadState state;

    public ActorThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorTimerQueue timerQueue, boolean metricsEnabled) {
        this(name, id, threadGroup, taskScheduler, clock, timerQueue, metricsEnabled, ActorScheduler.ActorSchedulerBuilder.defaultIdleStrategySupplier());
    }

    public ActorThread(String name, int id, ActorThreadGroup threadGroup, TaskScheduler taskScheduler, ActorClock clock, ActorTimerQueue timerQueue, boolean metricsEnabled, IdleStrategy idleStrategy) {
        this.setName(name);
        this.state = ActorThreadState.NEW;
        this.threadId = id;
        this.clock = clock != null ? clock : new DefaultActorClock();
        this.timerJobQueue = timerQueue != null ? timerQueue : new ActorTimerQueue(this.clock);
        this.actorThreadGroup = threadGroup;
        this.taskScheduler = taskScheduler;
        this.actorMetrics = new ActorMetrics(metricsEnabled);
        this.idleStrategy = new ActorTaskRunnerIdleStrategy(idleStrategy);
    }

    ActorMetrics getActorMetrics() {
        return this.actorMetrics;
    }

    private void doWork() {
        this.submittedCallbacks.drain((Consumer)this);
        if (this.clock.update()) {
            this.timerJobQueue.processExpiredTimers(this.clock);
        }
        this.currentTask = this.taskScheduler.getNextTask();
        if (this.currentTask != null) {
            String actorName = this.currentTask.actor.getName();
            try (Histogram.Timer timer = this.actorMetrics.startExecutionTimer(actorName);){
                this.executeCurrentTask();
            }
            if (this.actorMetrics.isEnabled()) {
                this.actorMetrics.updateJobQueueLength(actorName, this.currentTask.estimateQueueLength());
                this.actorMetrics.countExecution(actorName);
            }
        } else {
            this.idleStrategy.onIdle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCurrentTask() {
        Map<String, String> properties = this.currentTask.getActor().getContext();
        boolean resubmit = false;
        for (Map.Entry<String, String> property : properties.entrySet()) {
            MDC.put((String)property.getKey(), (String)property.getValue());
        }
        this.idleStrategy.onTaskExecuted();
        try {
            resubmit = this.currentTask.execute(this);
        }
        catch (Throwable e) {
            FATAL_ERROR_HANDLER.handleError(e);
            LOG.error("Unexpected error occurred in task {}", (Object)this.currentTask, (Object)e);
        }
        finally {
            this.clock.update();
            properties.keySet().forEach(MDC::remove);
        }
        if (resubmit) {
            this.currentTask.resubmit();
        }
    }

    public void hintWorkAvailable() {
        this.idleStrategy.hintWorkAvailable();
    }

    public void scheduleTimer(TimerSubscription timer) {
        this.timerJobQueue.schedule(timer, this.clock);
    }

    public void removeTimer(TimerSubscription timer) {
        this.timerJobQueue.remove(timer);
    }

    public static ActorThread current() {
        return Thread.currentThread() instanceof ActorThread ? (ActorThread)Thread.currentThread() : null;
    }

    public static ActorThread ensureCalledFromActorThread(String methodName) {
        ActorThread thread = ActorThread.current();
        if (thread == null) {
            throw new UnsupportedOperationException("Incorrect usage of actor. " + methodName + ": must be called from actor thread");
        }
        return thread;
    }

    public static boolean isCalledFromActorThread() {
        ActorThread thread = ActorThread.current();
        return thread != null;
    }

    public ActorJob newJob() {
        ActorJob job = this.jobs.poll();
        if (job == null) {
            job = new ActorJob();
        }
        return job;
    }

    void recycleJob(ActorJob j) {
        j.reset();
        this.jobs.offer(j);
    }

    public int getRunnerId() {
        return this.threadId;
    }

    @Override
    public synchronized void start() {
        if (!STATE_HANDLE.compareAndSet(this, ActorThreadState.NEW, ActorThreadState.RUNNING)) {
            throw new IllegalStateException("Cannot start runner, not in state 'NEW'.");
        }
        super.start();
    }

    @Override
    public void run() {
        this.idleStrategy.init();
        MDC.put((String)"actor-scheduler", (String)this.actorThreadGroup.getSchedulerName());
        while (this.state == ActorThreadState.RUNNING) {
            try {
                this.doWork();
            }
            catch (Exception e) {
                LOG.error("Unexpected error occurred while in the actor thread {}", (Object)this.getName(), (Object)e);
            }
        }
        this.state = ActorThreadState.TERMINATED;
        this.terminationFuture.complete(null);
    }

    public CompletableFuture<Void> close() {
        if (STATE_HANDLE.compareAndSet(this, ActorThreadState.RUNNING, ActorThreadState.TERMINATING)) {
            return this.terminationFuture;
        }
        throw new IllegalStateException("Cannot stop runner, not in state 'RUNNING'.");
    }

    public ActorJob getCurrentJob() {
        ActorTask task = this.getCurrentTask();
        if (task != null) {
            return task.currentJob;
        }
        return null;
    }

    public ActorTask getCurrentTask() {
        return this.currentTask;
    }

    public ActorClock getClock() {
        return this.clock;
    }

    public ActorThreadGroup getActorThreadGroup() {
        return this.actorThreadGroup;
    }

    @Override
    public void accept(Runnable t) {
        t.run();
    }

    static {
        try {
            STATE_HANDLE = MethodHandles.lookup().findVarHandle(ActorThread.class, "state", ActorThreadState.class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ActorThreadState {
        NEW,
        RUNNING,
        TERMINATING,
        TERMINATED;

    }

    protected class ActorTaskRunnerIdleStrategy {
        private final IdleStrategy idleStrategy;
        private boolean isIdle;

        protected ActorTaskRunnerIdleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
        }

        void init() {
            this.isIdle = true;
        }

        public void hintWorkAvailable() {
            LockSupport.unpark(ActorThread.this);
        }

        protected void onIdle() {
            if (!this.isIdle) {
                ActorThread.this.clock.update();
                this.isIdle = true;
            }
            this.idleStrategy.idle();
        }

        protected void onTaskExecuted() {
            this.idleStrategy.reset();
            this.isIdle = false;
        }
    }
}

