/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

final class ActorMetrics {
    private static final Histogram EXECUTION_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().exponentialBuckets(1.0E-4, 4.0, 10).namespace("zeebe")).name("actor_task_execution_latency")).help("Execution time of a certain actor task")).labelNames(new String[]{"actorName"})).register();
    private static final Histogram SCHEDULING_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().exponentialBuckets((double)1.0E-6f, 4.0, 12).namespace("zeebe")).name("actor_job_scheduling_latency")).help("Time between scheduling and executing a job")).labelNames(new String[]{"subscriptionType"})).register();
    private static final Counter EXECUTION_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("actor_task_execution_count")).help("Number of times a certain actor task was executed successfully")).labelNames(new String[]{"actorName"})).register();
    private static final Gauge JOB_QUEUE_LENGTH = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("actor_task_queue_length")).help("The length of the job queue for an actor task")).labelNames(new String[]{"actorName"})).register();
    private final boolean enabled;

    public ActorMetrics(boolean metricsEnabled) {
        this.enabled = metricsEnabled;
    }

    Histogram.Timer startExecutionTimer(String name) {
        if (!this.enabled) {
            return null;
        }
        return ((Histogram.Child)EXECUTION_LATENCY.labels(new String[]{name})).startTimer();
    }

    void countExecution(String name) {
        if (this.enabled) {
            ((Counter.Child)EXECUTION_COUNT.labels(new String[]{name})).inc();
        }
    }

    void updateJobQueueLength(String actorName, int length) {
        if (this.enabled) {
            ((Gauge.Child)JOB_QUEUE_LENGTH.labels(new String[]{actorName})).set((double)length);
        }
    }

    public void observeJobSchedulingLatency(long waitTimeNs, String subscriptionType) {
        if (this.enabled) {
            ((Histogram.Child)SCHEDULING_LATENCY.labels(new String[]{subscriptionType})).observe((double)((float)waitTimeNs / 1.0E9f));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

