/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordMetadataDecoder;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.PostCommitTask;
import io.camunda.zeebe.stream.api.ProcessingResponse;
import io.camunda.zeebe.stream.api.ProcessingResult;
import io.camunda.zeebe.stream.api.ProcessingResultBuilder;
import io.camunda.zeebe.stream.api.records.RecordBatchSizePredicate;
import io.camunda.zeebe.stream.impl.BufferedResult;
import io.camunda.zeebe.stream.impl.TypedEventRegistry;
import io.camunda.zeebe.stream.impl.records.RecordBatch;
import io.camunda.zeebe.stream.impl.records.RecordBatchEntry;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.StringUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.List;

final class BufferedProcessingResultBuilder
implements ProcessingResultBuilder {
    private final List<PostCommitTask> postCommitTasks = new ArrayList<PostCommitTask>();
    private final RecordBatch mutableRecordBatch;
    private ProcessingResponseImpl processingResponse;
    private final long operationReference;

    BufferedProcessingResultBuilder(RecordBatchSizePredicate predicate) {
        this(predicate, RecordMetadataDecoder.operationReferenceNullValue());
    }

    BufferedProcessingResultBuilder(RecordBatchSizePredicate predicate, long operationReference) {
        this.mutableRecordBatch = new RecordBatch(predicate);
        this.operationReference = operationReference;
    }

    @Override
    public Either<RuntimeException, ProcessingResultBuilder> appendRecordReturnEither(long key, RecordValue value, RecordMetadata metadata) {
        ValueType valueType;
        if (this.operationReference != RecordMetadataDecoder.operationReferenceNullValue()) {
            metadata.operationReference(this.operationReference);
        }
        if ((valueType = TypedEventRegistry.TYPE_REGISTRY.get(value.getClass())) == null) {
            throw new IllegalStateException("Missing value type mapping for record: " + String.valueOf(value.getClass()));
        }
        if (value instanceof UnifiedRecordValue) {
            UnifiedRecordValue unifiedRecordValue = (UnifiedRecordValue)value;
            RecordMetadata metadataWithValueType = metadata.valueType(valueType);
            Either<RuntimeException, Void> either = this.mutableRecordBatch.appendRecord(key, metadataWithValueType, -1, (BufferWriter)unifiedRecordValue);
            if (either.isLeft()) {
                return Either.left((Object)((RuntimeException)either.getLeft()));
            }
        } else {
            throw new IllegalStateException(String.format("The record value %s is not a UnifiedRecordValue", StringUtil.limitString((String)value.toString(), (int)1024)));
        }
        return Either.right((Object)this);
    }

    @Override
    public ProcessingResultBuilder withResponse(RecordType recordType, long key, Intent intent, UnpackedObject value, ValueType valueType, RejectionType rejectionType, String rejectionReason, long requestId, int requestStreamId) {
        RecordMetadata metadata = new RecordMetadata().recordType(recordType).intent(intent).rejectionType(rejectionType).rejectionReason(rejectionReason).valueType(valueType).operationReference(this.operationReference);
        RecordBatchEntry entry = RecordBatchEntry.createEntry(key, metadata, -1, (BufferWriter)value);
        this.processingResponse = new ProcessingResponseImpl(entry, requestId, requestStreamId);
        return this;
    }

    @Override
    public ProcessingResultBuilder appendPostCommitTask(PostCommitTask task) {
        this.postCommitTasks.add(task);
        return this;
    }

    @Override
    public ProcessingResultBuilder resetPostCommitTasks() {
        this.postCommitTasks.clear();
        return this;
    }

    @Override
    public ProcessingResult build() {
        return new BufferedResult(this.mutableRecordBatch, this.processingResponse, this.postCommitTasks);
    }

    @Override
    public boolean canWriteEventOfLength(int eventLength) {
        return this.mutableRecordBatch.canAppendRecordOfLength(eventLength);
    }

    record ProcessingResponseImpl(RecordBatchEntry responseValue, long requestId, int requestStreamId) implements ProcessingResponse
    {
    }
}

