/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public final class StringUtil {
    public static final UnaryOperator<List<String>> LIST_SANITIZER = input -> Optional.ofNullable(input).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(String::trim).filter(Predicate.not(String::isEmpty)).collect(Collectors.toList());
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static byte[] getBytes(String value) {
        return StringUtil.getBytes(value, DEFAULT_CHARSET);
    }

    public static byte[] getBytes(String value, Charset charset) {
        return value.getBytes(charset);
    }

    public static String fromBytes(byte[] bytes) {
        return StringUtil.fromBytes(bytes, DEFAULT_CHARSET);
    }

    public static String fromBytes(byte[] bytes, Charset charset) {
        return new String(bytes, charset);
    }

    public static String limitString(String message, int maxLength) {
        if (message.length() > maxLength) {
            return message.substring(0, maxLength).concat("...");
        }
        return message;
    }
}

