/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DecisionRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class PersistedDecision
extends UnpackedObject
implements DbValue {
    private final StringProperty decisionIdProp = new StringProperty("decisionId");
    private final StringProperty decisionNameProp = new StringProperty("decisionName");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty decisionKeyProp = new LongProperty("decisionKey");
    private final StringProperty decisionRequirementsIdProp = new StringProperty("decisionRequirementsId");
    private final LongProperty decisionRequirementsKeyProp = new LongProperty("decisionRequirementsKey");
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public PersistedDecision() {
        super(7);
        this.declareProperty((BaseProperty)this.decisionIdProp).declareProperty((BaseProperty)this.decisionNameProp).declareProperty((BaseProperty)this.versionProp).declareProperty((BaseProperty)this.decisionKeyProp).declareProperty((BaseProperty)this.decisionRequirementsIdProp).declareProperty((BaseProperty)this.decisionRequirementsKeyProp).declareProperty((BaseProperty)this.tenantIdProp);
    }

    public void wrap(DecisionRecord record) {
        this.decisionIdProp.setValue(record.getDecisionId());
        this.decisionNameProp.setValue(record.getDecisionName());
        this.versionProp.setValue(record.getVersion());
        this.decisionKeyProp.setValue(record.getDecisionKey());
        this.decisionRequirementsIdProp.setValue(record.getDecisionRequirementsIdBuffer());
        this.decisionRequirementsKeyProp.setValue(record.getDecisionRequirementsKey());
        this.tenantIdProp.setValue(record.getTenantId());
    }

    public PersistedDecision copy() {
        PersistedDecision copy = new PersistedDecision();
        copy.decisionIdProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getDecisionId()));
        copy.decisionNameProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getDecisionName()));
        copy.decisionKeyProp.setValue(this.getDecisionKey());
        copy.versionProp.setValue(this.getVersion());
        copy.decisionRequirementsIdProp.setValue(BufferUtil.cloneBuffer((DirectBuffer)this.getDecisionRequirementsId()));
        copy.decisionRequirementsKeyProp.setValue(this.getDecisionRequirementsKey());
        copy.tenantIdProp.setValue(this.getTenantId());
        return copy;
    }

    public DirectBuffer getDecisionId() {
        return this.decisionIdProp.getValue();
    }

    public DirectBuffer getDecisionName() {
        return this.decisionNameProp.getValue();
    }

    public int getVersion() {
        return this.versionProp.getValue();
    }

    public long getDecisionKey() {
        return this.decisionKeyProp.getValue();
    }

    public DirectBuffer getDecisionRequirementsId() {
        return this.decisionRequirementsIdProp.getValue();
    }

    public long getDecisionRequirementsKey() {
        return this.decisionRequirementsKeyProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public void setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
    }
}

