/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.engine.state.immutable.TimerInstanceState;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.engine.state.mutable.MutableTimerInstanceState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import java.util.function.Consumer;

public final class DbTimerInstanceState
implements MutableTimerInstanceState {
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbLong>, TimerInstance> timerInstanceColumnFamily;
    private final TimerInstance timerInstance = new TimerInstance();
    private final DbLong timerKey = new DbLong();
    private final DbForeignKey<DbLong> elementInstanceKey = new DbForeignKey((DbKey)new DbLong(), (Enum)ZbColumnFamilies.ELEMENT_INSTANCE_KEY, DbForeignKey.MatchType.Full, k -> k.getValue() == -1L);
    private final DbCompositeKey<DbForeignKey<DbLong>, DbLong> elementAndTimerKey = new DbCompositeKey(this.elementInstanceKey, (DbKey)this.timerKey);
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbForeignKey<DbLong>, DbLong>>, DbNil> dueDateColumnFamily;
    private final DbLong dueDate;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbForeignKey<DbLong>, DbLong>> dueDateCompositeKey;
    private long nextDueDate;

    public DbTimerInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.timerInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TIMERS, transactionContext, this.elementAndTimerKey, (DbValue)this.timerInstance);
        this.dueDate = new DbLong();
        this.dueDateCompositeKey = new DbCompositeKey((DbKey)this.dueDate, this.elementAndTimerKey);
        this.dueDateColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TIMER_DUE_DATES, transactionContext, this.dueDateCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void store(TimerInstance timer) {
        this.timerKey.wrapLong(timer.getKey());
        ((DbLong)this.elementInstanceKey.inner()).wrapLong(timer.getElementInstanceKey());
        this.timerInstanceColumnFamily.insert(this.elementAndTimerKey, (DbValue)timer);
        this.dueDate.wrapLong(timer.getDueDate());
        this.dueDateColumnFamily.insert(this.dueDateCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    @Override
    public void remove(TimerInstance timer) {
        ((DbLong)this.elementInstanceKey.inner()).wrapLong(timer.getElementInstanceKey());
        this.timerKey.wrapLong(timer.getKey());
        this.timerInstanceColumnFamily.deleteExisting(this.elementAndTimerKey);
        this.dueDate.wrapLong(timer.getDueDate());
        this.dueDateColumnFamily.deleteExisting(this.dueDateCompositeKey);
    }

    @Override
    public long processTimersWithDueDateBefore(long timestamp, TimerInstanceState.TimerVisitor consumer) {
        this.nextDueDate = -1L;
        this.dueDateColumnFamily.whileTrue((key, nil) -> {
            long dueDate = ((DbLong)key.first()).getValue();
            DbCompositeKey elementAndTimerKey = (DbCompositeKey)key.second();
            boolean consumed = false;
            if (dueDate <= timestamp) {
                TimerInstance timerInstance = (TimerInstance)this.timerInstanceColumnFamily.get((DbKey)elementAndTimerKey);
                if (timerInstance == null) {
                    return true;
                }
                consumed = consumer.visit(timerInstance);
            }
            if (!consumed) {
                this.nextDueDate = dueDate;
            }
            return consumed;
        });
        return this.nextDueDate;
    }

    @Override
    public void forEachTimerForElementInstance(long elementInstanceKey, Consumer<TimerInstance> action) {
        ((DbLong)this.elementInstanceKey.inner()).wrapLong(elementInstanceKey);
        this.timerInstanceColumnFamily.whileEqualPrefix(this.elementInstanceKey, (key, value) -> action.accept((TimerInstance)((Object)value)));
    }

    @Override
    public TimerInstance get(long elementInstanceKey, long timerKey) {
        ((DbLong)this.elementInstanceKey.inner()).wrapLong(elementInstanceKey);
        this.timerKey.wrapLong(timerKey);
        return (TimerInstance)this.timerInstanceColumnFamily.get(this.elementAndTimerKey);
    }
}

