/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_5.corrections;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbBytes;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import io.camunda.zeebe.engine.state.migration.DbMigratorImpl;
import io.camunda.zeebe.engine.state.migration.to_8_5.corrections.ColumnFamilyCorrectionException;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFamily49Corrector {
    private static final Logger LOG = LoggerFactory.getLogger((String)DbMigratorImpl.class.getPackageName());
    private static final ZbColumnFamilies CF_UNDER_RECOVERY = ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION;
    private static final ZbColumnFamilies CF_POSSIBLE_TARGET = ZbColumnFamilies.PROCESS_INSTANCE_KEY_BY_DEFINITION_KEY;
    private final ColumnFamily<DbBytes, DbBytes> recoverColumnFamily;
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> processInstanceKeyByProcessDefinitionKeyColumnFamily;
    private final DbCompositeKey<DbLong, DbLong> processInstanceKeyByProcessDefinitionKey;
    private final DbLong processDefinitionKey;
    private final DbLong elementInstanceKey;
    private final DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;

    public ColumnFamily49Corrector(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.recoverColumnFamily = zeebeDb.createColumnFamily((Enum)CF_UNDER_RECOVERY, transactionContext, (DbKey)new DbBytes(), (DbValue)new DbBytes());
        this.processDefinitionKey = new DbLong();
        this.elementInstanceKey = new DbLong();
        this.processInstanceKeyByProcessDefinitionKey = new DbCompositeKey((DbKey)this.processDefinitionKey, (DbKey)this.elementInstanceKey);
        this.processInstanceKeyByProcessDefinitionKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.PROCESS_INSTANCE_KEY_BY_DEFINITION_KEY, transactionContext, this.processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
        DbString dbDecisionRequirementsId = new DbString();
        DbInt dbDecisionRequirementsVersion = new DbInt();
        this.decisionRequirementsIdAndVersion = new DbCompositeKey((DbKey)dbDecisionRequirementsId, (DbKey)dbDecisionRequirementsVersion);
    }

    public void correctColumnFamilyPrefix() {
        this.recoverColumnFamily.forEach((key, value) -> {
            if (!this.isKeyWithExpectedLength((DbBytes)key)) {
                LOG.trace("Found invalid key [{}] (incorrect key length) in column family [{}] {}", new Object[]{key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name()});
                this.tryMoveDataToCorrectColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            try {
                this.decisionRequirementsIdAndVersion.wrap(key.getDirectBuffer(), 0, key.getLength());
            }
            catch (Exception e) {
                LOG.trace("Found invalid key [{}] (unable to read key) in column family [{}] {}", new Object[]{key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name()});
                this.tryMoveDataToCorrectColumnFamily((DbBytes)key, (DbBytes)value);
            }
            if (value.getLength() != 8) {
                LOG.trace("Found invalid value [{}] (incorrect value length) in column family [{}] {}", new Object[]{value, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name()});
                this.tryMoveDataToCorrectColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            LOG.trace("Found valid dmn requirements key entry with key[{}] in recovery column family", key);
        });
    }

    private boolean isKeyWithExpectedLength(DbBytes key) {
        int stringLength = key.getDirectBuffer().getInt(0, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        return key.getLength() == 4 + stringLength + 4;
    }

    private void tryMoveDataToCorrectColumnFamily(DbBytes key, DbBytes value) {
        try {
            this.processInstanceKeyByProcessDefinitionKey.wrap(key.getDirectBuffer(), 0, key.getLength());
        }
        catch (Exception e) {
            String reason = "unexpected data in column family";
            throw new ColumnFamilyCorrectionException("unexpected data in column family", key, value, CF_UNDER_RECOVERY, e);
        }
        if (value.getLength() != DbNil.INSTANCE.getLength()) {
            String reason = "unexpected data in column family";
            throw new ColumnFamilyCorrectionException("unexpected data in column family", key, value, CF_UNDER_RECOVERY);
        }
        this.moveEntryFromRecoveryColumnFamilyToCorrectColumnFamily(key, this.processInstanceKeyByProcessDefinitionKey);
    }

    private void moveEntryFromRecoveryColumnFamilyToCorrectColumnFamily(DbBytes key, DbCompositeKey<DbLong, DbLong> processInstanceKeyByProcessDefinitionKey) {
        LOG.debug("Copying entry with key [{}] from column family [{}] {} to column family [{}] {}", new Object[]{key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name(), CF_POSSIBLE_TARGET.ordinal(), CF_POSSIBLE_TARGET.name()});
        this.processInstanceKeyByProcessDefinitionKeyColumnFamily.upsert(processInstanceKeyByProcessDefinitionKey, (DbValue)DbNil.INSTANCE);
        this.deleteEntryFromRecoveryColumnFamily(key);
    }

    private void deleteEntryFromRecoveryColumnFamily(DbBytes key) {
        LOG.debug("Deleting entry with key[{}] from column family [{}] {}", new Object[]{key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name()});
        this.recoverColumnFamily.deleteExisting((DbKey)key);
    }
}

