/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableReceiveTask;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.util.Either;

public final class ReceiveTaskProcessor
implements BpmnElementProcessor<ExecutableReceiveTask> {
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;

    public ReceiveTaskProcessor(BpmnBehaviors behaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.eventSubscriptionBehavior = behaviors.eventSubscriptionBehavior();
        this.incidentBehavior = behaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = behaviors.variableMappingBehavior();
        this.stateBehavior = behaviors.stateBehavior();
        this.compensationSubscriptionBehaviour = behaviors.compensationSubscriptionBehaviour();
    }

    @Override
    public Class<ExecutableReceiveTask> getType() {
        return ExecutableReceiveTask.class;
    }

    @Override
    public Either<Failure, ?> onActivate(ExecutableReceiveTask element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.eventSubscriptionBehavior.subscribeToEvents(element, context)).thenDo(ok -> this.stateTransitionBehavior.transitionToActivated(context, element.getEventType()));
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableReceiveTask element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> {
            this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
            this.compensationSubscriptionBehaviour.createCompensationSubscription(element, context);
            return this.stateTransitionBehavior.transitionToCompleted(element, context);
        }).thenDo(completed -> {
            this.compensationSubscriptionBehaviour.completeCompensationHandler((BpmnElementContext)completed);
            this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed);
        });
    }

    @Override
    public void onTerminate(ExecutableReceiveTask element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).filter(eventTrigger -> !flowScopeInstance.isInterrupted()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }
}

