/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;

public final class SubProcessTransformer
implements ModelElementTransformer<SubProcess> {
    @Override
    public Class<SubProcess> getType() {
        return SubProcess.class;
    }

    @Override
    public void transform(SubProcess element, TransformContext context) {
        ExecutableProcess currentProcess = context.getCurrentProcess();
        ExecutableFlowElementContainer subprocess = currentProcess.getElementById(element.getId(), ExecutableFlowElementContainer.class);
        if (element.triggeredByEvent()) {
            this.transformEventSubprocess(element, currentProcess, subprocess);
        }
    }

    private void transformEventSubprocess(SubProcess element, ExecutableProcess currentProcess, ExecutableFlowElementContainer subprocess) {
        subprocess.setElementType(BpmnElementType.EVENT_SUB_PROCESS);
        if (element.getScope() instanceof FlowNode) {
            FlowNode scope = (FlowNode)element.getScope();
            ExecutableFlowElementContainer parentSubProc = currentProcess.getElementById(scope.getId(), ExecutableFlowElementContainer.class);
            parentSubProc.attach(subprocess);
        } else {
            currentProcess.attach(subprocess);
        }
        ExecutableStartEvent startEvent = subprocess.getStartEvents().iterator().next();
        startEvent.setEventSubProcess(subprocess.getId());
    }
}

