/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableScriptTask;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe.ScriptTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe.TaskDefinitionTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformer.zeebe.TaskHeadersTransformer;
import io.camunda.zeebe.model.bpmn.instance.FlowElement;
import io.camunda.zeebe.model.bpmn.instance.ScriptTask;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeScript;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskDefinition;
import io.camunda.zeebe.model.bpmn.instance.zeebe.ZeebeTaskHeaders;

public final class ScriptTaskTransformer
implements ModelElementTransformer<ScriptTask> {
    private final TaskDefinitionTransformer taskDefinitionTransformer = new TaskDefinitionTransformer();
    private final TaskHeadersTransformer taskHeadersTransformer = new TaskHeadersTransformer();
    private final ScriptTransformer scriptTransformer = new ScriptTransformer();

    @Override
    public Class<ScriptTask> getType() {
        return ScriptTask.class;
    }

    @Override
    public void transform(ScriptTask element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableScriptTask executableTask = process.getElementById(element.getId(), ExecutableScriptTask.class);
        ZeebeTaskDefinition taskDefinition = (ZeebeTaskDefinition)element.getSingleExtensionElement(ZeebeTaskDefinition.class);
        this.taskDefinitionTransformer.transform(executableTask, context, taskDefinition);
        ZeebeTaskHeaders taskHeaders = (ZeebeTaskHeaders)element.getSingleExtensionElement(ZeebeTaskHeaders.class);
        this.taskHeadersTransformer.transform(executableTask, taskHeaders, (FlowElement)element);
        ZeebeScript zeebeScript = (ZeebeScript)element.getSingleExtensionElement(ZeebeScript.class);
        this.scriptTransformer.transform(executableTask, context, zeebeScript);
    }
}

