/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.auth.impl.TenantAuthorizationCheckerImpl;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.immutable.ElementInstanceState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.Map;
import java.util.Optional;

public final class ProcessInstanceCancelProcessor
implements TypedRecordProcessor<ProcessInstanceRecord> {
    private static final String MESSAGE_PREFIX = "Expected to cancel a process instance with key '%d', but ";
    private static final String PROCESS_NOT_FOUND_MESSAGE = "Expected to cancel a process instance with key '%d', but no such process was found";
    private static final String PROCESS_NOT_ROOT_MESSAGE = "Expected to cancel a process instance with key '%d', but it is created by a parent process instance. Cancel the root process instance '%d' instead.";
    private final ElementInstanceState elementInstanceState;
    private final TypedResponseWriter responseWriter;
    private final TypedCommandWriter commandWriter;
    private final TypedRejectionWriter rejectionWriter;

    public ProcessInstanceCancelProcessor(ProcessingState processingState, Writers writers) {
        this.elementInstanceState = processingState.getElementInstanceState();
        this.responseWriter = writers.response();
        this.commandWriter = writers.command();
        this.rejectionWriter = writers.rejection();
    }

    @Override
    public void processRecord(TypedRecord<ProcessInstanceRecord> command) {
        ElementInstance elementInstance = this.elementInstanceState.getInstance(command.getKey());
        if (!this.validateCommand(command, elementInstance)) {
            return;
        }
        ProcessInstanceRecord value = elementInstance.getValue();
        this.commandWriter.appendFollowUpCommand(command.getKey(), (Intent)ProcessInstanceIntent.TERMINATE_ELEMENT, (RecordValue)value);
        this.responseWriter.writeEventOnCommand(command.getKey(), (Intent)ProcessInstanceIntent.ELEMENT_TERMINATING, (UnpackedObject)value, command);
    }

    private boolean validateCommand(TypedRecord<ProcessInstanceRecord> command, ElementInstance elementInstance) {
        if (elementInstance == null || !elementInstance.canTerminate() || elementInstance.getParentKey() > 0L) {
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, String.format(PROCESS_NOT_FOUND_MESSAGE, command.getKey()));
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, String.format(PROCESS_NOT_FOUND_MESSAGE, command.getKey()));
            return false;
        }
        if (!TenantAuthorizationCheckerImpl.fromAuthorizationMap((Map)command.getAuthorizations()).isAuthorized(elementInstance.getValue().getTenantId()).booleanValue()) {
            this.rejectionWriter.appendRejection(command, RejectionType.NOT_FOUND, String.format(PROCESS_NOT_FOUND_MESSAGE, command.getKey()));
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.NOT_FOUND, String.format(PROCESS_NOT_FOUND_MESSAGE, command.getKey()));
            return false;
        }
        long parentProcessInstanceKey = elementInstance.getValue().getParentProcessInstanceKey();
        if (parentProcessInstanceKey > 0L) {
            long rootProcessInstanceKey = this.getRootProcessInstanceKey(parentProcessInstanceKey);
            this.rejectionWriter.appendRejection(command, RejectionType.INVALID_STATE, String.format(PROCESS_NOT_ROOT_MESSAGE, command.getKey(), rootProcessInstanceKey));
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.INVALID_STATE, String.format(PROCESS_NOT_ROOT_MESSAGE, command.getKey(), rootProcessInstanceKey));
            return false;
        }
        return true;
    }

    private long getRootProcessInstanceKey(long instanceKey) {
        Optional<Long> parentInstanceKey = this.getParentInstanceKey(instanceKey);
        while (parentInstanceKey.isPresent()) {
            instanceKey = parentInstanceKey.get();
            parentInstanceKey = this.getParentInstanceKey(instanceKey);
        }
        return instanceKey;
    }

    private Optional<Long> getParentInstanceKey(long instanceKey) {
        long parentProcessInstanceKey;
        ElementInstance instance = this.elementInstanceState.getInstance(instanceKey);
        if (instance != null && (parentProcessInstanceKey = instance.getValue().getParentProcessInstanceKey()) > 0L) {
            return Optional.of(parentProcessInstanceKey);
        }
        return Optional.empty();
    }
}

