/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.clock;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.clock.DbClockModification;
import io.camunda.zeebe.engine.state.mutable.MutableClockState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.stream.api.StreamClock;

public class DbClockState
implements MutableClockState {
    private static final String KEY = "MODIFICATION";
    private final ColumnFamily<DbString, DbClockModification> columnFamily;
    private final DbString key = new DbString();
    private final DbClockModification value = new DbClockModification();

    public DbClockState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.columnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.CLOCK, transactionContext, (DbKey)this.key, (DbValue)this.value);
    }

    @Override
    public MutableClockState pinAt(long epochMillis) {
        this.value.pinAt(epochMillis);
        this.key.wrapString(KEY);
        this.columnFamily.upsert((DbKey)this.key, (DbValue)this.value);
        return this;
    }

    @Override
    public MutableClockState offsetBy(long offsetMillis) {
        this.value.offsetBy(offsetMillis);
        this.key.wrapString(KEY);
        this.columnFamily.upsert((DbKey)this.key, (DbValue)this.value);
        return this;
    }

    @Override
    public MutableClockState reset() {
        this.value.reset();
        this.key.wrapString(KEY);
        this.columnFamily.upsert((DbKey)this.key, (DbValue)this.value);
        return this;
    }

    @Override
    public StreamClock.ControllableStreamClock.Modification getModification() {
        this.key.wrapString(KEY);
        DbClockModification modification = (DbClockModification)this.columnFamily.get((DbKey)this.key);
        if (modification == null) {
            return StreamClock.ControllableStreamClock.Modification.none();
        }
        return modification.modification();
    }
}

