/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.user;

import io.camunda.zeebe.engine.processing.distribution.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.streamprocessor.DistributedTypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedRejectionWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedResponseWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.distribution.DistributionQueue;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.engine.state.immutable.UserState;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.record.value.user.UserRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.UserIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.api.state.KeyGenerator;
import org.agrona.DirectBuffer;

public class UserCreateProcessor
implements DistributedTypedRecordProcessor<UserRecord> {
    private final UserState userState;
    private final KeyGenerator keyGenerator;
    private final StateWriter stateWriter;
    private final TypedRejectionWriter rejectionWriter;
    private final TypedResponseWriter responseWriter;
    private final CommandDistributionBehavior distributionBehavior;

    public UserCreateProcessor(KeyGenerator keyGenerator, ProcessingState state, Writers writers, CommandDistributionBehavior distributionBehavior) {
        this.userState = state.getUserState();
        this.keyGenerator = keyGenerator;
        this.stateWriter = writers.state();
        this.rejectionWriter = writers.rejection();
        this.responseWriter = writers.response();
        this.distributionBehavior = distributionBehavior;
    }

    @Override
    public void processNewCommand(TypedRecord<UserRecord> command) {
        DirectBuffer username = ((UserRecord)command.getValue()).getUsernameBuffer();
        UserRecord user = this.userState.getUser(username);
        if (user != null) {
            this.rejectionWriter.appendRejection(command, RejectionType.ALREADY_EXISTS, "Expected to create user with username %s, but a user with this username already exists".formatted(user.getUsername()));
            this.responseWriter.writeRejectionOnCommand(command, RejectionType.ALREADY_EXISTS, "Expected to create user with username %s, but a user with this username already exists".formatted(user.getUsername()));
            return;
        }
        long key = this.keyGenerator.nextKey();
        ((UserRecord)command.getValue()).setUserKey(Long.valueOf(key));
        this.stateWriter.appendFollowUpEvent(key, (Intent)UserIntent.CREATED, (RecordValue)command.getValue());
        this.responseWriter.writeEventOnCommand(key, (Intent)UserIntent.CREATED, (UnpackedObject)command.getValue(), command);
        this.distributionBehavior.withKey(key).inQueue(DistributionQueue.IDENTITY.getQueueId()).distribute(command);
    }

    @Override
    public void processDistributedCommand(TypedRecord<UserRecord> command) {
        this.stateWriter.appendFollowUpEvent(command.getKey(), (Intent)UserIntent.CREATED, (RecordValue)command.getValue());
        this.distributionBehavior.acknowledgeCommand(command);
    }
}

