/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.restful.ws.impl;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.http.restful.ws.impl.CloudEventsHeaders;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.OutputStream;

public final class RestfulWSMessageWriter
implements CloudEventWriter<Void>,
MessageWriter<RestfulWSMessageWriter, Void> {
    private final MultivaluedMap<String, Object> httpHeaders;
    private final OutputStream entityStream;

    public RestfulWSMessageWriter(MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) {
        this.httpHeaders = httpHeaders;
        this.entityStream = entityStream;
        this.httpHeaders.remove((Object)"Content-Type");
    }

    public RestfulWSMessageWriter create(SpecVersion version) {
        this.httpHeaders.add((Object)CloudEventsHeaders.SPEC_VERSION, (Object)version.toString());
        return this;
    }

    public RestfulWSMessageWriter withContextAttribute(String name, String value) throws CloudEventRWException {
        String headerName = CloudEventsHeaders.ATTRIBUTES_TO_HEADERS.get(name);
        if (headerName == null) {
            headerName = "ce-" + name;
        }
        this.httpHeaders.add((Object)headerName, (Object)value);
        return this;
    }

    public Void end(CloudEventData value) throws CloudEventRWException {
        try {
            this.entityStream.write(value.toBytes());
        }
        catch (IOException e) {
            throw CloudEventRWException.newOther((Throwable)e);
        }
        return this.end();
    }

    public Void end() {
        try {
            this.entityStream.flush();
        }
        catch (IOException e) {
            throw CloudEventRWException.newOther((Throwable)e);
        }
        return null;
    }

    public Void setEvent(EventFormat format, byte[] value) throws CloudEventRWException {
        this.httpHeaders.add((Object)"Content-Type", (Object)format.serializedContentType());
        try {
            this.entityStream.write(value);
        }
        catch (IOException e) {
            throw CloudEventRWException.newOther((Throwable)e);
        }
        return this.end();
    }
}

