/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.table;

import java.util.List;

public class TablePrinter {
    private int[][] cellLengths;
    private int[] maxLengths;

    public void printTable(List<List<String>> table, StringBuilder result) {
        this.calculateColumnAndMaxLengths(table);
        for (int i = 0; i < table.size(); ++i) {
            this.printRow(table.get(i), i, result);
            result.append("\n");
        }
    }

    protected void printStartIndent(StringBuilder buffer, int rowIndex) {
        buffer.append("      ");
    }

    private void calculateColumnAndMaxLengths(List<List<String>> rows) {
        int columnCount = 0;
        for (List<String> row : rows) {
            if (columnCount >= row.size()) continue;
            columnCount = row.size();
        }
        this.cellLengths = new int[rows.size()][columnCount];
        this.maxLengths = new int[columnCount];
        for (int rowIndex = 0; rowIndex < rows.size(); ++rowIndex) {
            List<String> cells = rows.get(rowIndex);
            for (int colIndex = 0; colIndex < columnCount; ++colIndex) {
                int length;
                String cell = this.getCellSafely(cells, colIndex);
                this.cellLengths[rowIndex][colIndex] = length = this.escapeCell(cell).length();
                this.maxLengths[colIndex] = Math.max(this.maxLengths[colIndex], length);
            }
        }
    }

    private String getCellSafely(List<String> cells, int colIndex) {
        return colIndex < cells.size() ? cells.get(colIndex) : "";
    }

    private void printRow(List<String> cells, int rowIndex, StringBuilder buffer) {
        this.printStartIndent(buffer, rowIndex);
        buffer.append("| ");
        for (int colIndex = 0; colIndex < this.maxLengths.length; ++colIndex) {
            String cellText = this.escapeCell(this.getCellSafely(cells, colIndex));
            buffer.append(cellText);
            int padding = this.maxLengths[colIndex] - this.cellLengths[rowIndex][colIndex];
            this.padSpace(buffer, padding);
            if (colIndex < this.maxLengths.length - 1) {
                buffer.append(" | ");
                continue;
            }
            buffer.append(" |");
        }
    }

    private String escapeCell(String cell) {
        return cell.replaceAll("\\\\(?!\\|)", "\\\\\\\\").replaceAll("\\n", "\\\\n").replaceAll("\\|", "\\\\|");
    }

    private void padSpace(StringBuilder buffer, int indent) {
        for (int i = 0; i < indent; ++i) {
            buffer.append(" ");
        }
    }
}

