/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.Result;
import cucumber.api.TestStep;
import cucumber.api.event.TestCaseFinished;
import cucumber.api.event.TestCaseStarted;
import cucumber.runner.EventBus;
import cucumber.runner.HookTestStep;
import cucumber.runner.PickleStepTestStep;
import cucumber.runtime.ScenarioImpl;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleLocation;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.List;

class TestCase
implements cucumber.api.TestCase {
    private final PickleEvent pickleEvent;
    private final List<PickleStepTestStep> testSteps;
    private final boolean dryRun;
    private final List<HookTestStep> beforeHooks;
    private final List<HookTestStep> afterHooks;

    public TestCase(List<PickleStepTestStep> testSteps, List<HookTestStep> beforeHooks, List<HookTestStep> afterHooks, PickleEvent pickleEvent, boolean dryRun) {
        this.testSteps = testSteps;
        this.beforeHooks = beforeHooks;
        this.afterHooks = afterHooks;
        this.pickleEvent = pickleEvent;
        this.dryRun = dryRun;
    }

    void run(EventBus bus) {
        Result stepResult;
        boolean skipNextStep = this.dryRun;
        Long startTime = bus.getTime();
        bus.send(new TestCaseStarted(startTime, this));
        ScenarioImpl scenarioResult = new ScenarioImpl(bus, this.pickleEvent);
        for (HookTestStep before : this.beforeHooks) {
            stepResult = before.run(bus, this.pickleEvent.pickle.getLanguage(), scenarioResult, this.dryRun);
            skipNextStep |= !stepResult.is(Result.Type.PASSED);
            scenarioResult.add(stepResult);
        }
        for (PickleStepTestStep step : this.testSteps) {
            skipNextStep |= !(stepResult = step.run(bus, this.pickleEvent.pickle.getLanguage(), scenarioResult, skipNextStep)).is(Result.Type.PASSED);
            scenarioResult.add(stepResult);
        }
        for (HookTestStep after : this.afterHooks) {
            stepResult = after.run(bus, this.pickleEvent.pickle.getLanguage(), scenarioResult, this.dryRun);
            scenarioResult.add(stepResult);
        }
        Long stopTime = bus.getTime();
        bus.send(new TestCaseFinished(stopTime, this, new Result(scenarioResult.getStatus(), stopTime - startTime, scenarioResult.getError())));
    }

    @Override
    public List<TestStep> getTestSteps() {
        ArrayList<TestStep> testSteps = new ArrayList<TestStep>();
        testSteps.addAll(this.beforeHooks);
        for (PickleStepTestStep step : this.testSteps) {
            testSteps.addAll(step.getBeforeStepHookSteps());
            testSteps.add(step);
            testSteps.addAll(step.getAfterStepHookSteps());
        }
        testSteps.addAll(this.afterHooks);
        return testSteps;
    }

    @Override
    public String getName() {
        return this.pickleEvent.pickle.getName();
    }

    @Override
    public String getScenarioDesignation() {
        return this.fileColonLine((PickleLocation)this.pickleEvent.pickle.getLocations().get(0)) + " # " + this.getName();
    }

    @Override
    public String getUri() {
        return this.pickleEvent.uri;
    }

    @Override
    public int getLine() {
        return ((PickleLocation)this.pickleEvent.pickle.getLocations().get(0)).getLine();
    }

    private String fileColonLine(PickleLocation location) {
        return this.pickleEvent.uri + ":" + location.getLine();
    }

    @Override
    public List<PickleTag> getTags() {
        return this.pickleEvent.pickle.getTags();
    }
}

