/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.stepexpression;

import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import io.cucumber.stepexpression.Argument;
import io.cucumber.stepexpression.ArgumentMatcher;
import io.cucumber.stepexpression.PickleTableConverter;
import io.cucumber.stepexpression.StepExpression;
import java.util.List;

public class ExpressionArgumentMatcher
implements ArgumentMatcher {
    private final StepExpression expression;

    public ExpressionArgumentMatcher(StepExpression expression) {
        this.expression = expression;
    }

    @Override
    public List<Argument> argumentsFrom(PickleStep step) {
        if (step.getArgument().isEmpty()) {
            return this.expression.match(step.getText());
        }
        gherkin.pickles.Argument argument = (gherkin.pickles.Argument)step.getArgument().get(0);
        if (argument instanceof PickleString) {
            return this.expression.match(step.getText(), ((PickleString)argument).getContent());
        }
        if (argument instanceof PickleTable) {
            return this.expression.match(step.getText(), PickleTableConverter.toTable((PickleTable)argument));
        }
        throw new IllegalStateException("Argument was neither PickleString nor PickleTable");
    }
}

