/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.StepDefinitionReporter;
import cucumber.runner.AmbiguousStepDefinitionsException;
import cucumber.runner.HookComparator;
import cucumber.runner.PickleStepDefinitionMatch;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import gherkin.pickles.PickleStep;
import io.cucumber.stepexpression.Argument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

final class Glue
implements cucumber.runtime.Glue {
    final Map<String, StepDefinition> stepDefinitionsByPattern = new TreeMap<String, StepDefinition>();
    final List<HookDefinition> beforeHooks = new ArrayList<HookDefinition>();
    final List<HookDefinition> beforeStepHooks = new ArrayList<HookDefinition>();
    final List<HookDefinition> afterHooks = new ArrayList<HookDefinition>();
    final List<HookDefinition> afterStepHooks = new ArrayList<HookDefinition>();
    final Map<String, CacheEntry> matchedStepDefinitionsCache = new HashMap<String, CacheEntry>();

    Glue() {
    }

    @Override
    public void addStepDefinition(StepDefinition stepDefinition) {
        StepDefinition previous = this.stepDefinitionsByPattern.get(stepDefinition.getPattern());
        if (previous != null) {
            throw new DuplicateStepDefinitionException(previous, stepDefinition);
        }
        this.stepDefinitionsByPattern.put(stepDefinition.getPattern(), stepDefinition);
    }

    @Override
    public void addBeforeHook(HookDefinition hookDefinition) {
        this.beforeHooks.add(hookDefinition);
        Collections.sort(this.beforeHooks, new HookComparator(true));
    }

    @Override
    public void addBeforeStepHook(HookDefinition hookDefinition) {
        this.beforeStepHooks.add(hookDefinition);
        Collections.sort(this.beforeStepHooks, new HookComparator(true));
    }

    @Override
    public void addAfterHook(HookDefinition hookDefinition) {
        this.afterHooks.add(hookDefinition);
        Collections.sort(this.afterHooks, new HookComparator(false));
    }

    @Override
    public void addAfterStepHook(HookDefinition hookDefinition) {
        this.afterStepHooks.add(hookDefinition);
        Collections.sort(this.afterStepHooks, new HookComparator(false));
    }

    List<HookDefinition> getBeforeHooks() {
        return this.beforeHooks;
    }

    List<HookDefinition> getBeforeStepHooks() {
        return this.beforeStepHooks;
    }

    List<HookDefinition> getAfterHooks() {
        return this.afterHooks;
    }

    List<HookDefinition> getAfterStepHooks() {
        return this.afterStepHooks;
    }

    PickleStepDefinitionMatch stepDefinitionMatch(String featurePath, PickleStep step) {
        String stepText = step.getText();
        CacheEntry cacheEntry = this.matchedStepDefinitionsCache.get(stepText);
        if (cacheEntry != null) {
            return new PickleStepDefinitionMatch(Collections.emptyList(), cacheEntry.stepDefinition, featurePath, step);
        }
        List<PickleStepDefinitionMatch> matches = this.stepDefinitionMatches(featurePath, step);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() > 1) {
            throw new AmbiguousStepDefinitionsException(step, matches);
        }
        PickleStepDefinitionMatch match = matches.get(0);
        if (match.getArguments().isEmpty()) {
            this.matchedStepDefinitionsCache.put(stepText, new CacheEntry(match.getStepDefinition()));
        }
        return match;
    }

    private List<PickleStepDefinitionMatch> stepDefinitionMatches(String featurePath, PickleStep step) {
        ArrayList<PickleStepDefinitionMatch> result = new ArrayList<PickleStepDefinitionMatch>();
        for (StepDefinition stepDefinition : this.stepDefinitionsByPattern.values()) {
            List<Argument> arguments = stepDefinition.matchedArguments(step);
            if (arguments == null) continue;
            result.add(new PickleStepDefinitionMatch(arguments, stepDefinition, featurePath, step));
        }
        return result;
    }

    void reportStepDefinitions(StepDefinitionReporter stepDefinitionReporter) {
        for (StepDefinition stepDefinition : this.stepDefinitionsByPattern.values()) {
            stepDefinitionReporter.stepDefinition(stepDefinition);
        }
    }

    @Override
    public void removeScenarioScopedGlue() {
        this.removeScenarioScopedHooks(this.beforeHooks);
        this.removeScenarioScopedHooks(this.beforeStepHooks);
        this.removeScenarioScopedHooks(this.afterHooks);
        this.removeScenarioScopedHooks(this.afterStepHooks);
        this.removeScenarioScopedStepdefs();
    }

    private void removeScenarioScopedHooks(List<HookDefinition> beforeHooks1) {
        Iterator<HookDefinition> hookIterator = beforeHooks1.iterator();
        while (hookIterator.hasNext()) {
            HookDefinition hook = hookIterator.next();
            if (!hook.isScenarioScoped()) continue;
            hookIterator.remove();
        }
    }

    private void removeScenarioScopedStepdefs() {
        Iterator<Map.Entry<String, StepDefinition>> stepdefs = this.stepDefinitionsByPattern.entrySet().iterator();
        while (stepdefs.hasNext()) {
            StepDefinition stepDefinition = stepdefs.next().getValue();
            if (!stepDefinition.isScenarioScoped()) continue;
            stepdefs.remove();
        }
        Iterator<Map.Entry<String, CacheEntry>> cachedStepDefs = this.matchedStepDefinitionsCache.entrySet().iterator();
        while (cachedStepDefs.hasNext()) {
            StepDefinition stepDefinition = cachedStepDefs.next().getValue().stepDefinition;
            if (!stepDefinition.isScenarioScoped()) continue;
            cachedStepDefs.remove();
        }
    }

    static final class CacheEntry {
        StepDefinition stepDefinition;

        private CacheEntry(StepDefinition stepDefinition) {
            this.stepDefinition = stepDefinition;
        }
    }
}

