/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.Argument;
import cucumber.api.PickleStepTestStep;
import cucumber.api.Result;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventListener;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestSourceRead;
import cucumber.api.event.TestStepFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.api.event.WriteEvent;
import cucumber.api.formatter.ColorAware;
import cucumber.api.formatter.NiceAppendable;
import cucumber.runtime.formatter.AnsiFormats;
import cucumber.runtime.formatter.Format;
import cucumber.runtime.formatter.Formats;
import cucumber.runtime.formatter.MonochromeFormats;
import cucumber.runtime.formatter.TestSourcesModel;
import cucumber.util.FixJava;
import cucumber.util.Mapper;
import gherkin.ast.Background;
import gherkin.ast.Examples;
import gherkin.ast.Feature;
import gherkin.ast.ScenarioDefinition;
import gherkin.ast.ScenarioOutline;
import gherkin.ast.Step;
import gherkin.ast.Tag;
import gherkin.pickles.PickleTag;
import java.util.List;

final class PrettyFormatter
implements EventListener,
ColorAware {
    private static final String SCENARIO_INDENT = "  ";
    private static final String STEP_INDENT = "    ";
    private static final String EXAMPLES_INDENT = "    ";
    private final TestSourcesModel testSources = new TestSourcesModel();
    private final NiceAppendable out;
    private Formats formats;
    private String currentFeatureFile;
    private TestCase currentTestCase;
    private ScenarioOutline currentScenarioOutline;
    private Examples currentExamples;
    private int locationIndentation;
    private Mapper<Tag, String> tagNameMapper = new Mapper<Tag, String>(){

        @Override
        public String map(Tag tag) {
            return tag.getName();
        }
    };
    private Mapper<PickleTag, String> pickleTagNameMapper = new Mapper<PickleTag, String>(){

        @Override
        public String map(PickleTag pickleTag) {
            return pickleTag.getName();
        }
    };
    private EventHandler<TestSourceRead> testSourceReadHandler = new EventHandler<TestSourceRead>(){

        @Override
        public void receive(TestSourceRead event) {
            PrettyFormatter.this.handleTestSourceRead(event);
        }
    };
    private EventHandler<TestCaseStarted> caseStartedHandler = new EventHandler<TestCaseStarted>(){

        @Override
        public void receive(TestCaseStarted event) {
            PrettyFormatter.this.handleTestCaseStarted(event);
        }
    };
    private EventHandler<TestStepStarted> stepStartedHandler = new EventHandler<TestStepStarted>(){

        @Override
        public void receive(TestStepStarted event) {
            PrettyFormatter.this.handleTestStepStarted(event);
        }
    };
    private EventHandler<TestStepFinished> stepFinishedHandler = new EventHandler<TestStepFinished>(){

        @Override
        public void receive(TestStepFinished event) {
            PrettyFormatter.this.handleTestStepFinished(event);
        }
    };
    private EventHandler<WriteEvent> writeEventhandler = new EventHandler<WriteEvent>(){

        @Override
        public void receive(WriteEvent event) {
            PrettyFormatter.this.handleWrite(event);
        }
    };
    private EventHandler<TestRunFinished> runFinishedHandler = new EventHandler<TestRunFinished>(){

        @Override
        public void receive(TestRunFinished event) {
            PrettyFormatter.this.finishReport();
        }
    };

    public PrettyFormatter(Appendable out) {
        this.out = new NiceAppendable(out);
        this.formats = new AnsiFormats();
    }

    @Override
    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestSourceRead.class, this.testSourceReadHandler);
        publisher.registerHandlerFor(TestCaseStarted.class, this.caseStartedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.stepStartedHandler);
        publisher.registerHandlerFor(TestStepFinished.class, this.stepFinishedHandler);
        publisher.registerHandlerFor(WriteEvent.class, this.writeEventhandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishedHandler);
    }

    @Override
    public void setMonochrome(boolean monochrome) {
        this.formats = monochrome ? new MonochromeFormats() : new AnsiFormats();
    }

    private void handleTestSourceRead(TestSourceRead event) {
        this.testSources.addTestSourceReadEvent(event.uri, event);
    }

    private void handleTestCaseStarted(TestCaseStarted event) {
        this.handleStartOfFeature(event);
        this.handleScenarioOutline(event);
        if (this.testSources.hasBackground(this.currentFeatureFile, event.testCase.getLine())) {
            this.printBackground(event.testCase);
            this.currentTestCase = event.testCase;
        } else {
            this.printScenarioDefinition(event.testCase);
        }
    }

    private void handleTestStepStarted(TestStepStarted event) {
        if (event.testStep instanceof PickleStepTestStep && this.isFirstStepAfterBackground((PickleStepTestStep)event.testStep)) {
            this.printScenarioDefinition(this.currentTestCase);
            this.currentTestCase = null;
        }
    }

    private void handleTestStepFinished(TestStepFinished event) {
        if (event.testStep instanceof PickleStepTestStep) {
            this.printStep((PickleStepTestStep)event.testStep, event.result);
        }
        this.printError(event.result);
    }

    private void handleWrite(WriteEvent event) {
        this.out.println(event.text);
    }

    private void finishReport() {
        this.out.close();
    }

    private void handleStartOfFeature(TestCaseStarted event) {
        if (this.currentFeatureFile == null || !this.currentFeatureFile.equals(event.testCase.getUri())) {
            if (this.currentFeatureFile != null) {
                this.out.println();
            }
            this.currentFeatureFile = event.testCase.getUri();
            this.printFeature(this.currentFeatureFile);
        }
    }

    private void handleScenarioOutline(TestCaseStarted event) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, event.testCase.getLine());
        if (TestSourcesModel.isScenarioOutlineScenario(astNode)) {
            ScenarioOutline scenarioOutline = (ScenarioOutline)TestSourcesModel.getScenarioDefinition(astNode);
            if (this.currentScenarioOutline == null || !this.currentScenarioOutline.equals(scenarioOutline)) {
                this.currentScenarioOutline = scenarioOutline;
                this.printScenarioOutline(this.currentScenarioOutline);
            }
            if (this.currentExamples == null || !this.currentExamples.equals(astNode.parent.node)) {
                this.currentExamples = (Examples)astNode.parent.node;
                this.printExamples(this.currentExamples);
            }
        } else {
            this.currentScenarioOutline = null;
            this.currentExamples = null;
        }
    }

    private void printScenarioOutline(ScenarioOutline scenarioOutline) {
        this.out.println();
        this.printTags(scenarioOutline.getTags(), SCENARIO_INDENT);
        this.out.println(SCENARIO_INDENT + this.getScenarioDefinitionText((ScenarioDefinition)scenarioOutline) + " " + this.getLocationText(this.currentFeatureFile, scenarioOutline.getLocation().getLine()));
        this.printDescription(scenarioOutline.getDescription());
        for (Step step : scenarioOutline.getSteps()) {
            this.out.println("    " + this.formats.get("skipped").text(step.getKeyword() + step.getText()));
        }
    }

    private void printExamples(Examples examples) {
        this.out.println();
        this.printTags(examples.getTags(), "    ");
        this.out.println("    " + examples.getKeyword() + ": " + examples.getName());
        this.printDescription(examples.getDescription());
    }

    private void printStep(PickleStepTestStep testStep, Result result) {
        String keyword = this.getStepKeyword(testStep);
        String stepText = testStep.getStepText();
        String locationPadding = this.createPaddingToLocation("    ", keyword + stepText);
        String formattedStepText = this.formatStepText(keyword, stepText, this.formats.get(result.getStatus().lowerCaseName()), this.formats.get(result.getStatus().lowerCaseName() + "_arg"), testStep.getDefinitionArgument());
        this.out.println("    " + formattedStepText + locationPadding + this.getLocationText(testStep.getCodeLocation()));
    }

    String formatStepText(String keyword, String stepText, Format textFormat, Format argFormat, List<Argument> arguments) {
        int beginIndex = 0;
        StringBuilder result = new StringBuilder(textFormat.text(keyword));
        for (Argument argument : arguments) {
            if (argument.getValue() != null) {
                int argumentOffset = argument.getStart();
                if (argumentOffset < beginIndex) continue;
                String text = stepText.substring(beginIndex, argumentOffset);
                result.append(textFormat.text(text));
            }
            if (argument.getValue() == null) continue;
            String text = stepText.substring(argument.getStart(), argument.getEnd());
            result.append(argFormat.text(text));
            beginIndex = argument.getEnd();
        }
        if (beginIndex != stepText.length()) {
            String text = stepText.substring(beginIndex, stepText.length());
            result.append(textFormat.text(text));
        }
        return result.toString();
    }

    private String getScenarioDefinitionText(ScenarioDefinition definition) {
        return definition.getKeyword() + ": " + definition.getName();
    }

    private String getLocationText(String file, int line) {
        return this.getLocationText(file + ":" + line);
    }

    private String getLocationText(String location) {
        return this.formats.get("comment").text("# " + location);
    }

    private StringBuffer stepText(PickleStepTestStep testStep) {
        String keyword = this.getStepKeyword(testStep);
        return new StringBuffer(keyword + testStep.getStepText());
    }

    private String getStepKeyword(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        if (astNode != null) {
            Step step = (Step)astNode.node;
            return step.getKeyword();
        }
        return "";
    }

    private boolean isFirstStepAfterBackground(PickleStepTestStep testStep) {
        return this.currentTestCase != null && !this.isBackgroundStep(testStep);
    }

    private boolean isBackgroundStep(PickleStepTestStep testStep) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testStep.getStepLine());
        if (astNode != null) {
            return TestSourcesModel.isBackgroundStep(astNode);
        }
        return false;
    }

    private void printFeature(String path) {
        Feature feature = this.testSources.getFeature(path);
        this.printTags(feature.getTags());
        this.out.println(feature.getKeyword() + ": " + feature.getName());
        this.printDescription(feature.getDescription());
    }

    private void printTags(List<Tag> tags) {
        this.printTags(tags, "");
    }

    private void printTags(List<Tag> tags, String indent) {
        if (!tags.isEmpty()) {
            this.out.println(indent + FixJava.join(FixJava.map(tags, this.tagNameMapper), " "));
        }
    }

    private void printPickleTags(List<PickleTag> tags, String indent) {
        if (!tags.isEmpty()) {
            this.out.println(indent + FixJava.join(FixJava.map(tags, this.pickleTagNameMapper), " "));
        }
    }

    private void printDescription(String description) {
        if (description != null) {
            this.out.println(description);
        }
    }

    private void printBackground(TestCase testCase) {
        TestSourcesModel.AstNode astNode = this.testSources.getAstNode(this.currentFeatureFile, testCase.getLine());
        if (astNode != null) {
            Background background = TestSourcesModel.getBackgroundForTestCase(astNode);
            String backgroundText = this.getScenarioDefinitionText((ScenarioDefinition)background);
            boolean useBackgroundSteps = true;
            this.calculateLocationIndentation(SCENARIO_INDENT + backgroundText, testCase.getTestSteps(), useBackgroundSteps);
            String locationPadding = this.createPaddingToLocation(SCENARIO_INDENT, backgroundText);
            this.out.println();
            this.out.println(SCENARIO_INDENT + backgroundText + locationPadding + this.getLocationText(this.currentFeatureFile, background.getLocation().getLine()));
            this.printDescription(background.getDescription());
        }
    }

    private void printScenarioDefinition(TestCase testCase) {
        ScenarioDefinition scenarioDefinition = this.testSources.getScenarioDefinition(this.currentFeatureFile, testCase.getLine());
        String definitionText = scenarioDefinition.getKeyword() + ": " + testCase.getName();
        this.calculateLocationIndentation(SCENARIO_INDENT + definitionText, testCase.getTestSteps());
        String locationPadding = this.createPaddingToLocation(SCENARIO_INDENT, definitionText);
        this.out.println();
        this.printPickleTags(testCase.getTags(), SCENARIO_INDENT);
        this.out.println(SCENARIO_INDENT + definitionText + locationPadding + this.getLocationText(this.currentFeatureFile, testCase.getLine()));
        this.printDescription(scenarioDefinition.getDescription());
    }

    private void printError(Result result) {
        if (result.getError() != null) {
            this.out.println("      " + this.formats.get(result.getStatus().lowerCaseName()).text(result.getErrorMessage()));
        }
    }

    private void calculateLocationIndentation(String definitionText, List<TestStep> testSteps) {
        boolean useBackgroundSteps = false;
        this.calculateLocationIndentation(definitionText, testSteps, useBackgroundSteps);
    }

    private void calculateLocationIndentation(String definitionText, List<TestStep> testSteps, boolean useBackgroundSteps) {
        int maxTextLength = definitionText.length();
        for (TestStep step : testSteps) {
            PickleStepTestStep testStep;
            if (!(step instanceof PickleStepTestStep) || this.isBackgroundStep(testStep = (PickleStepTestStep)step) != useBackgroundSteps) continue;
            StringBuffer stepText = this.stepText(testStep);
            maxTextLength = Math.max(maxTextLength, "    ".length() + stepText.length());
        }
        this.locationIndentation = maxTextLength + 1;
    }

    private String createPaddingToLocation(String indent, String text) {
        StringBuffer padding = new StringBuffer();
        for (int i = indent.length() + text.length(); i < this.locationIndentation; ++i) {
            padding.append(' ');
        }
        return padding.toString();
    }
}

