/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.io;

import cucumber.runtime.ClassFinder;
import cucumber.runtime.io.Resource;
import cucumber.runtime.io.ResourceLoader;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;

public class ResourceLoaderClassFinder
implements ClassFinder {
    private static final String CLASS_SUFFIX = ".class";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final char DOT = '.';
    private static final char PACKAGE_PATH_SEPARATOR = '/';
    private final ResourceLoader resourceLoader;
    private final ClassLoader classLoader;

    public ResourceLoaderClassFinder(ResourceLoader resourceLoader, ClassLoader classLoader) {
        this.resourceLoader = resourceLoader;
        this.classLoader = classLoader;
    }

    @Override
    public <T> Collection<Class<? extends T>> getDescendants(Class<T> parentType, String packageName) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (Resource classResource : this.resourceLoader.resources(this.packagePath(packageName), CLASS_SUFFIX)) {
            String className = this.getClassName(classResource.getPath().getSchemeSpecificPart());
            try {
                Class<T> clazz = this.loadClass(className);
                if (clazz == null || parentType.equals(clazz) || !parentType.isAssignableFrom(clazz)) continue;
                result.add(clazz.asSubclass(parentType));
            }
            catch (ClassNotFoundException | NoClassDefFoundError throwable) {}
        }
        return result;
    }

    private URI packagePath(String packageName) {
        return URI.create(CLASSPATH_PREFIX + packageName.replace('.', '/'));
    }

    private String getClassName(String path) {
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path.substring(0, path.length() - CLASS_SUFFIX.length()).replace('/', '.');
    }

    @Override
    public <T> Class<? extends T> loadClass(String className) throws ClassNotFoundException {
        return this.classLoader.loadClass(className);
    }
}

